#include "mbed.h"
#include "C12832.h"
#include "Stoperica.h"

Stoperica::Stoperica(PinName startPausePin, PinName stopPin) : startPause(startPausePin), stop(stopPin), lcd(p5, p7, p6, p8, p11) {
    isMeasurementStarted = false;
    startPause.rise(this, &Stoperica::startPausePressed);
    stop.rise(this, &Stoperica::stopPressed);
    debounceStartPause.start();
    debounceStop.start();
    lcd.cls();
    lcd.locate(0,3);
    lcd.printf("PURS_ZI_002\nStart measurement");
}

void Stoperica::startPausePressed() {
    if(debounceStartPause.read_ms() > 5) {
        if (!isMeasurementStarted) {
            passedTime.start();
            isMeasurementStarted = true;
        } else {
            passedTime.stop();
            isMeasurementStarted = false;
        }
        debounceStartPause.reset();
        lcd.cls();
        lcd.locate(0,3);
        lcd.printf("Passed time: %g", passedTime.read());
    }
}

void Stoperica::stopPressed() {
    if(debounceStop.read_ms() > 5) {
        passedTime.stop();
        passedTime.reset();
        debounceStop.reset();
        lcd.cls();
        lcd.locate(0,3);
        lcd.printf("PURS_ZI_002\nStart measurement");
    }
}