#include "mbed.h"
#include "C12832.h"
#include "Stoperica.h"

Stoperica::Stoperica(PinName startPin, PinName stopPin) : start(startPin), stop(stopPin), lcd(p5, p7, p6, p8, p11) {
    start.rise(this, &Stoperica::startPressed);
    stop.rise(this, &Stoperica::stopPressed);
    debounceStart.start();
    debounceStop.start();
    lcd.cls();
    lcd.locate(0,3);
    lcd.printf("PURS_ZI_001\nPress start/stop button");
}

void Stoperica::startPressed() {
    if(debounceStart.read_ms() > 5) {
        passedTime.start();
        debounceStart.reset();
        lcd.cls();
        lcd.locate(0,3);
        lcd.printf("Measurement in progress");
    }
}

void Stoperica::stopPressed() {
    if(debounceStop.read_ms() > 5) {
        passedTime.stop();
        debounceStop.reset();
        lcd.cls();
        lcd.locate(0,3);
        lcd.printf("Passed time: %g", passedTime.read());
        passedTime.reset();
    }
}