#include "mbed.h"
#include "StepperDriver.h"

StepperDriver stepper(p26, p29);
DigitalOut CDENBLN(p17);
DigitalOut CDUSM1(p16);
DigitalOut CDUSM0(p28);
DigitalOut CDRESETn(p15);
DigitalOut DECAY(p18);

float t = 0, period = 2;

int main() {
    
    CDENBLN = 0;            //Logicka 0 ukljucuje elektromotor, 1 iskljucuje
    CDUSM1 = 0;             // 1/8 micro step mode ==1, full step mode == 0
    CDUSM0 = 0;             // 1/8 micro step mode ==1, full step mode == 0
    CDRESETn = 1;           //Logicka 0 ukljucuje indekser ali gasi H-most
    DECAY = 0;              //Logicka 0 slow decay, 1 za mixed decay

    stepper.setPosition(720);
    wait(2);
    while(t < 10*period) {
        stepper.setPosition(720+360*sin(2*3.14159f/period*t));
        t += 0.05;
        wait(0.05);
    }
    stepper.setPosition(0);
    CDENBLN = 1;
}