#include "mbed.h"

PwmOut speaker(p26);
AnalogIn pot1(p19);
AnalogIn pot2(p20);
DigitalIn joystickCenter(p14);
 
int main() {
    // note frequencies in Hz
    // rows: C C# D Eb E F F# G G# A Bb B
    //columns: 0 1 2 3 4 5 6 7 8

    enum noteNames {C, Cs, D, Eb, E, F, Fs, G, Gs, A, Bb, B};
    float nt[12][9] = { {16.35}, {17.32}, {18.35}, {19.45}, {20.60}, {21.83},
                        {23.12}, {24.5}, {25.96}, {27.5}, {29.14}, {30.87} };
    for (int i = 0; i < 12; i++) 
        for (int j = 1; j < 9; j++) 
            nt[i][j] = nt[i][j-1] * 2;
    
    while(1) {
        //int scale = pot2 * 8;
        float speed = 0.05 + pot1; // minimum wait is 50 ms
        float notesCiciban[] = {nt[A][1], 0, nt[A][1], 0, nt[A][1], 0,
                                nt[F][1], 0, nt[C][2], 0, nt[A][1], 0,
                                nt[F][1], 0, nt[C][2], 0, nt[A][1], 0, 
                                nt[E][2], 0, nt[E][2], 0, nt[E][2], 0,
                                nt[F][2], 0, nt[C][2], 0, nt[Gs][1], 0, 
                                nt[F][1], 0, nt[C][2], 0, nt[A][1], 0,
                                nt[A][2], 0, nt[A][1], 0, nt[A][1], 0,
                                nt[A][2], 0, nt[Gs][2], 0, nt[G][2], 0,
                                nt[Fs][2], 0, nt[F][2], 0, nt[Fs][2], 0,
                                nt[Bb][1], 0, nt[Eb][2], 0, nt[D][2], 0,
                                nt[Cs][2], 0, nt[C][2], 0, nt[B][1], 0,
                                nt[C][2], 0, nt[F][1], 0, nt[Gs][1], 0,
                                nt[F][1], 0, nt[Gs][1], 0, nt[C][2], 0,
                                nt[A][1], 0, nt[C][2], 0, nt[E][2], 0,
                                nt[A][2], 0, nt[A][1], 0, nt[A][1], 0,
                                nt[A][2], 0, nt[Gs][2], 0, nt[G][2], 0,
                                nt[Fs][2], 0, nt[F][2], 0, nt[Fs][2], 0,
                                nt[Bb][1], 0, nt[Eb][2], 0, nt[D][2], 0,
                                nt[Cs][2], 0,};
        float beatCiciban[] =  {1, 0.5, 1, 0.5, 1, 0.5,
                                0.5, 0.5, 0.5, 0.5, 1, 0.5,
                                0.5, 0.5, 0.5, 0.5, 2, 0.5, 
                                1, 0.5, 1, 0.5, 1, 0.5, 
                                0.5, 0.5, 0.5, 0.5, 1, 0.5,
                                0.5, 0.5, 0.5, 0.5, 2, 0.5,
                                1, 0.5, 0.5, 0.5, 0.5, 0.5,
                                1, 0.5, 0.5, 0.5, 0.5, 0.5,
                                0.25, 0.5, 0.25, 0.5, 0.25, 0.5,
                                0.25, 0.5, 1, 0.5, 0.5, 0.5,
                                0.5, 0.5, 0.25, 0.5, 0.25, 0.5,
                                0.25, 0.5, 0.25, 0.5, 1, 0.5,
                                0.5, 0.5, 0.5, 0.5, 1, 0.5,
                                0.5, 0.5, 0.5, 0.5, 2, 0.5,
                                1, 0.5, 0.5, 0.5, 0.5, 0.5,
                                1, 0.5, 0.5, 0.5, 0.5, 0.5,
                                0.25, 0.5, 0.25, 0.5, 0.25, 0.5,
                                0.25, 0.5, 1, 0.5, 0.5, 0.5,
                                0.5, 0.5};
    
        for (int i = 0; i < 109; i++) {
            speaker.period(1 / (4*notesCiciban[i]) );
            speaker = 0.75;
            wait(speed * beatCiciban[i]);
        }
        if (joystickCenter) // press joystick center to stop playing
            break;
    }
}