#include "mbed.h"
#include "C12832.h"
#include "SinusGen.h"

SinusGen::SinusGen(PinName pot1Pin, PinName pot2Pin, PinName tipkaloPin) : pot1(pot1Pin), pot2(pot2Pin), tipkalo(tipkaloPin), lcd(p5, p7, p6, p8, p11), led1(LED1), led2(LED2), led3(LED3), led4(LED4) {
    ticker.attach(this, &SinusGen::generirajPrikazi, 0.05);
    tipkalo.rise(this, &SinusGen::izborLedice);
    lcd.cls();
    izbor = 0;
    t = 0;
    led1 = led2 = led3 = led4 = 0;
    debounce.start();
}

void SinusGen::generirajPrikazi() {
    U = pot1.read();
    A = pot2.read();
    t += 0.05;
    y = U + A*sin(3.14f*t);
    lcd.locate(0,3);
    lcd.printf("y(t) = %.2f + %.2fsin(3.14t)", U, A);
    led1 = led2 = led3 = led4 = 0;
    switch(izbor) {
        case 0:
            led1 = y;
            break;
        case 1:
            led2 = y;
            break;
        case 2:
            led3 = y;
            break;
        case 3:
            led4 = y;
            break;
    }
}

void SinusGen::izborLedice() {
    if (debounce.read_ms() > 20) {
        izbor = ++izbor % 4;
        debounce.reset();
    }
}