#include "SevenSegmentDisplay.h"

SevenSegmentDisplay::SevenSegmentDisplay(PinName a, 
                                         PinName b, 
                                         PinName c, 
                                         PinName d, 
                                         PinName e, 
                                         PinName f, 
                                         PinName g, 
                                         PinName dp,
                                         ConnectionMode mode):
                           display(dp, g, f, e, d, c, b, a) 
{
    display.output();
    if (mode == CommonAnode)
        display.mode(OpenDrain);
    this->mode = mode;
    init();
}

void SevenSegmentDisplay::init() {
    if (mode == CommonAnode)
        display = 0xFF;
    else
        display = 0x00;
}

void SevenSegmentDisplay::turnOn(int disp) {
    if (mode == CommonAnode)
        display = disp;
    else
        display = ~disp;
}

void SevenSegmentDisplay::print(char c) {
    switch(c) {              // a b c d  e f g dp 
    case '0':
        turnOn(0x03);        // 0 0 0 0  0 0 1 1 (CommonAnode, ~CommonCathode)
        break;
    case '1':
        turnOn(0x9F);        // 1 0 0 1  1 1 1 1 (CommonAnode, ~CommonCathode)
        break;
    case '2':
        turnOn(0x25);        // 0 0 1 0  0 1 0 1 (CommonAnode, ~CommonCathode)
        break;
    case '3':
        turnOn(0x0D);        // 0 0 0 0  1 1 0 1 (CommonAnode, ~CommonCathode)
        break;
    case '4':
        turnOn(0x99);        // 1 0 0 1  1 0 0 1 (CommonAnode, ~CommonCathode)
        break;
    case '5':
        turnOn(0x49);        // 0 1 0 0  1 0 0 1 (CommonAnode, ~CommonCathode)
        break;
    case '6':
        turnOn(0x41);        // 0 1 0 0  0 0 0 1 (CommonAnode, ~CommonCathode)
        break;
    case '7':
        turnOn(0x1F);        // 0 0 0 1  1 1 1 1 (CommonAnode, ~CommonCathode)
        break;
    case '8':
        turnOn(0x01);        // 0 0 0 0  0 0 0 1 (CommonAnode, ~CommonCathode)
        break;
    case '9':
        turnOn(0x09);        // 0 0 0 0  1 0 0 1 (CommonAnode, ~CommonCathode)
        break;
    default:
        init();
    }
}