#ifndef SEVEN_SEGMENT_DISPLAY_H_KEY
#define SEVEN_SEGMENT_DISPLAY_H_KEY

#include "mbed.h"

enum ConnectionMode {CommonAnode, CommonCathode};

/** A class for controling the output of 7-segment displays connected in 
 * common anode or common cathode mode.
 *
 * Author: Toni Bjazic, TVZ Mechatronics Team
 *
 * Example of use:
 * @code
 * #include "mbed.h"
 * #include "SevenSegmentDisplay.h"
 * 
 * Serial pc(USBTX, USBRX);
 *
 * int main() {
 *     SevenSegmentDisplay display(p5, p6, p7, p8, p9, p10, p11, p12, CommonCathode);
 *     char c;
 *     while(1) {
 *         pc.printf("\n\rEnter character to show on 7-segment display: ");
 *         pc.scanf("%c", &c);
 *         display.print(c);
 *         wait(0.2);
 *     }
 * }
 * @endcode
 */
class SevenSegmentDisplay {
public:
    /** Constructor receives pins on which the segments a, b, c, d, e, f, g and dp
     * are connected (respectively). Last (9th) argument is connection mode (CommonAnode
     * or CommonCathode), and defaults to CommonAnode.
     */
    SevenSegmentDisplay(PinName a,
                        PinName b, 
                        PinName c, 
                        PinName d, 
                        PinName e, 
                        PinName f, 
                        PinName g, 
                        PinName dp,
                        ConnectionMode = CommonAnode);
    
    /** Member function which initializes the display.
     */
    void init();
    
    /** Member function which prints the character on the 7-segment display.
     */
    void print(char);
private:
    BusInOut display;
    ConnectionMode mode;
    void turnOn(int);
};

#endif