#include "mbed.h"
#include "iostream"
#include "ThingSpeak.h"
#include "Sensor.h"
#include "C12832.h"
#include "INA219.h"



    ThingSpeak ts("074MPWFODR7JHD1K"); 
    C12832 lcd(p5, p7, p6, p8, p11);
    Sensor current(p19,4.65);
    Sensor voltage(p20,16.23);
   


int main() {
    INA219 ina219;
    float U, I, ina[3];
    int i;
    
    lcd.cls();
    lcd.locate(0,3);  
    lcd.printf("Ethernet Connecting ! \n");  
    ts.connect();
    lcd.printf("Ethernet Connected ! \n");
    wait(1);
    
    while(1){
                  
        U = voltage.read();       
        I = current.read();
        ina[0] = ina219.readRawReg(0x04);//* Current *//
        ina[1] = ina219.readRawReg(0x02); //* Bus Voltage *//
        ina[2] = ina219.readRawReg(0x03);//* Power *// 
    
        lcd.cls();
        lcd.locate(0,3);    
        lcd.printf("V = %.2f V \n",ina[1]);
        lcd.printf("I = %.2f A \n",ina[0]);
        lcd.printf("P = %.2f W \n",ina[2]);
        
        i = 1;
        ts.setField(U, i++);
        ts.setField(I, i++); 
        ts.setField(I*U, i++); 
        for(int j = 0 ; j<= 2; j++)
            ts.setField(ina[j], i++);
            
        ts.putUp();
        wait(15);                    
    }
}