#ifndef THINGSPEAK_H
#define THINGSPEAK_H
#define HOSTNAME "mbed"
#include "mbed.h"
#include "EthernetNetIf.h"
#include "HTTPClient.h"

/** Class for sending data to ThingSpeak over ethernet,
 *  Class is using old mbed library revision and EthernetNetIf from
 *  https://developer.mbed.org/users/okini3939/notebook/TCPSocket_jp/
 * Example:
 * @code
 * #include "mbed.h"
 * #include "ThingSpeak.h"
 *
 * ThingSpeak thingSpeak("XXXXXXXXXXXXXXXX");
 *
 * int main() {
 *     int i = 1;
 *     flot value = 3.14;
 *     thingSpeak.connect();
 *     thingSpeak.setField(value,i)
 *     thingSpeak.putUp();
 * }
 * @endcode
*/
class ThingSpeak
{

public:
    /**
     * @param: write api key provided from ThingSpeak chanell
    */
    ThingSpeak(char*);
    /**
     * Establishing ethernet connection until connected
     *
    */
    void connect();
    /**
     * Should be added
    */
    /**
    *        void getIP();
    */
    /**
     * Put up data to thing speak when all fields are set
    */
    void putUp();
    /**
     *Setting values to the field, they should be set in order.
     * It's not required to set them all  (example: you can set 1, 2, 3 or 1, 3)
     * @param field value to store on
     * @param i number of a field
    */
    void setField(float field, int i);
private:

    char* thingSpeakUrl;
    char* thingSpeakKey;
    char urlBuffer[511];
    char fieldBuffer[255];
    EthernetNetIf eth;
    EthernetErr ethErr;
    HTTPClient http;
    IpAddr ethIp;
    HTTPText resp;
    HTTPResult res;
};

#endif