#ifndef _SENSOR_H
#define SENSOR_H  
#include "mbed.h"

/** Simple class for sensor with linear otuput. Made for later upgrading, to avarage values from ADC
 * Example:
 * @code
 * #include "mbed.h"
 * #include "Sensor.h"
 * #include "INA219_reg.h"
 *
 * Sensor voltageDivider(p20,5);
 * float value;
 *
 * int main() {
 *     value = voltageDivider.read();
 * }
 * @endcode

*/
class Sensor {
     
     public:
    /**
     * @param: PinName of ADC to which sensor is connected
     *        float value for multiplifing with raw value from ADC to get real value
    */    
    Sensor(PinName, float);    
    /** Read real messured value
     * return: float real messured value 
     *
    **/                               
        float read();                                   
                                       
     private:
     
        AnalogIn sensorInput;           
        float readVal[], realVal, K;
};

#endif