#ifndef ROTIRKA_H
#define ROTIRKA_H

#include "mbed.h"
#include "C12832.h"

/** Rješenje ispita PURS_ZI_011 */
class Rotirka {
public:
    /** Konstruktor prima pinove tipkala i zvučnika.
     * @param tipkaloPin Pin tipkala.
     * @param zvucnikPin Pin na koji je spojen zvučnik.
     */
    Rotirka(PinName tipkaloPin, PinName zvucnikPin);
private:
    C12832 lcd;
    InterruptIn tipkalo;
    PwmOut zvucnik;
    BusOut leds;
    bool zvukOn;
    unsigned int modRada, modSvjetla;
    float frekvencija;
    Timer debounce, vrijeme;
    Ticker ticker1, ticker2;
    void odabirModa();
    void svijetli();
    void sirena();
};






#endif