#include "mbed.h"
#include "Rotirka.h"
#include "C12832.h"

Rotirka::Rotirka(PinName tipkaloPin, PinName zvucnikPin) : tipkalo(tipkaloPin), zvucnik(zvucnikPin), lcd(p5, p7, p6, p8, p11), leds(LED1, LED2, LED3, LED4) {
    debounce.start();
    tipkalo.rise(this, &Rotirka::odabirModa);
    modRada = 3;
    lcd.cls();
    lcd.locate(0,3);
    lcd.printf("Mod 4.");
    zvukOn = false;
    modSvjetla = 0;
    frekvencija = 1100;
    zvucnik.period(1/2.0f/frekvencija);
}

void Rotirka::odabirModa() {
    if(debounce.read_ms() > 10) {
        modRada = ++modRada % 4;
        switch(modRada+1) {
            case 1:
            ticker1.attach(this, &Rotirka::svijetli, 0.5);
            modSvjetla = 0; // opcionalno
            svijetli();
            lcd.locate(0,3);
            lcd.printf("Mod 1.");
            break;
            case 2:
            ticker1.detach();
            leds = 0;
            ticker2.attach(this, &Rotirka::sirena, 0.02);
            vrijeme.start();
            zvucnik = 0.5;
            lcd.locate(0,3);
            lcd.printf("Mod 2.");
            break;
            case 3:
            ticker1.attach(this, &Rotirka::svijetli, 0.5);
            modSvjetla = 0; // opcionalno
            lcd.locate(0,3);
            lcd.printf("Mod 3.");
            break;
            case 4:
            ticker1.detach();
            leds = 0;
            ticker2.detach();
            zvucnik = 0;
            leds = 0;
            vrijeme.reset();
            zvucnik.period(1/2.0f/1100);
            lcd.locate(0,3);
            lcd.printf("Mod 4.");
            break;
            default:
            break;
        }
        debounce.reset();
    }
}

void Rotirka::svijetli() {
    switch(modSvjetla) {
        case 0:
        leds = 1;
        break;
        case 1:
        leds = 2;
        break;
        case 2:
        leds = 4;
        break;
        case 3:
        leds = 8;
        break;
    }
    modSvjetla = ++modSvjetla % 4;
}

void Rotirka::sirena() {
    frekvencija = 1100 + 900*sin(2*3.14159f/5*vrijeme.read());
    zvucnik.period(1/2.0f/frekvencija);
}