#include "mbed.h"
#include "C12832.h"
#include "Mikrovalna.h"

Mikrovalna::Mikrovalna(PinName sekundePin, PinName startStopPin) : sekunde(sekundePin), startStop(startStopPin), lcd(p5, p7, p6, p8, p11), relej(LED1) {
    ukljucena = false;
    sekunde.rise(this, &Mikrovalna::namjestiVrijeme);
    startStop.rise(this, &Mikrovalna::ukljuciIskljuci);
    debounceSekunde.start();
    debounceStartStop.start();
    relej = 0;
    vrijeme = 0;
    lcd.cls();
    lcd.locate(0,3);
    lcd.printf("PURS_ZI_004\nNamjesti vrijeme/pokreni");
}

void Mikrovalna::ukljuciIskljuci() {
    if(debounceStartStop.read_ms() > 200) {
        if (!ukljucena && vrijeme > 0) {
            iskljuci.attach(this, &Mikrovalna::iskljucenje, vrijeme);
            relej = 1;
            ukljucena = true;
            lcd.cls();
            lcd.locate(0,3);
            lcd.printf("Ukljucena na %d s", vrijeme);
        } else {
            iskljuci.detach();
            relej = 0;
            vrijeme = 0;
            ukljucena = false;
            lcd.cls();
            lcd.locate(0,3);
            lcd.printf("Iskljucena");
        }
        debounceStartStop.reset();
    }
}

void Mikrovalna::iskljucenje() {
    relej = 0;
    vrijeme = 0;
    ukljucena = false;
    lcd.cls();
    lcd.locate(0,3);
    lcd.printf("Gotovo");
}

void Mikrovalna::namjestiVrijeme() {
    if(debounceSekunde.read_ms() > 200) {
        vrijeme += 5;
        if (vrijeme > 30) vrijeme = 0;
        debounceSekunde.reset();
        lcd.cls();
        lcd.locate(0,3);
        lcd.printf("%d", vrijeme);
    }
}