#include "mbed.h"

AnalogOut out(p18);
AnalogIn pot1(p19);
AnalogIn pot2(p20);

int main() {
    float A, f, T; // sine peak-to-peak amplitude, frequency and period
    float Ts; // sampling time
    const float PI = 3.14159265;
    int numberOfPoints = 100;
    while(1) {
        A = pot1; // amplitude in range 0 to 3.3 V
        f = 10 + 10 * pot2; // frequency in range 10 to 20 Hz
        T = 1/f;
        Ts = T / numberOfPoints;
        for (int i = 0; i < numberOfPoints; i++) {
            out = 0.5 + A/2 * sin(2 * PI * f * i * Ts);
            wait(Ts);
        }
    }
}