#include "mbed.h"

DigitalOut led1(LED1);
DigitalOut led2(LED2);
DigitalOut led3(LED3);
DigitalOut led4(LED4);

AnalogIn pot1(p19);
AnalogIn pot2(p20);

int main() {
    float valuePot1, valuePot2, valueAverage;
    while(1) {
        valuePot1 = pot1.read(); // the first way of reading from analog input
        valuePot2 = pot2; // the second (simpler) way of reading from analog input
        valueAverage = (valuePot1 + valuePot2) / 2; // calculate average
        if (valueAverage <= 0.2) { // turn off all LEDs
            led1 = 0;
            led2 = 0;
            led3 = 0;
            led4 = 0;
        } else if (valueAverage > 0.2 && valueAverage <= 0.4) { // turn LED1 on
            led1 = 1;
            led2 = 0;
            led3 = 0;
            led4 = 0;
        } else if (valueAverage > 0.4 && valueAverage <= 0.6) { // turn LED1 and LED2 on
            led1 = 1;
            led2 = 1;
            led3 = 0;
            led4 = 0;
        } else if (valueAverage > 0.6 && valueAverage <= 0.8) { // turn LED1, LED2 and LED3 on
            led1 = 1;
            led2 = 1;
            led3 = 1;
            led4 = 0;
        } else { // turn on all LEDs
            led1 = 1;
            led2 = 1;
            led3 = 1;
            led4 = 1;
        }
    }
}
