#include "mbed.h"
#include "Heater.h"
#include "C12832.h"

int main() {
    Heater h(p19, LED1);
    float minTemp = 18;
    float maxTemp = 26;
    h.configureSensor(minTemp, maxTemp);
    C12832 lcd(p5, p7, p6, p8, p11);
    lcd.cls();
    AnalogIn pot2(p20);
    float thermostat;
    while(true) {
        thermostat = minTemp + (maxTemp - minTemp) * pot2.read();
        h.setTemperature(thermostat);
        lcd.locate(0, 0);
        lcd.printf("Desired temperature: %.1f", thermostat);
        lcd.locate(0, 10);
        lcd.printf("Current temperature: %.1f", h.readTemperature());
        char s[4];
        if (h.isHeaterOn())
            strcpy(s, "ON ");
        else
            strcpy(s, "OFF");
        lcd.locate(0, 20);
        lcd.printf("Heater state: %s", s);
        wait(1);
    }
}