#include "mbed.h"
#include "Kuhalo.h"


Kuhalo::Kuhalo(PinName pinTipke1, PinName pinTipke2, PinName pinTipke3, PinName pinTipke4, PinName pinTipkeSnage) : 
        tipka1(pinTipke1), tipka2(pinTipke2), tipka3(pinTipke3), tipka4(pinTipke4), snaga(pinTipkeSnage), ploca1(LED1), ploca2(LED2), ploca3(LED3), ploca4(LED4) {
    tipka1.rise(this, &Kuhalo::odabirPloce1);
    tipka2.rise(this, &Kuhalo::odabirPloce2);
    tipka3.rise(this, &Kuhalo::odabirPloce3);
    tipka4.rise(this, &Kuhalo::odabirPloce4);
    snaga.rise(this, &Kuhalo::izborSnage);
    debounce.start();
    odabranaPloca = odabranaSnaga = 0;
}

void Kuhalo::odabirPloce1() {
    if (debounce.read_ms() > 20) {
        odabranaPloca = 1;
        debounce.reset();
        vrijemeZaIzborSnage.attach(this, &Kuhalo::ponistiOdabirPloce, 5);
    }
}

void Kuhalo::odabirPloce2() {
    if (debounce.read_ms() > 20) {
        odabranaPloca = 2;
        debounce.reset();
        vrijemeZaIzborSnage.attach(this, &Kuhalo::ponistiOdabirPloce, 5);
    }
}

void Kuhalo::odabirPloce3() {
    if (debounce.read_ms() > 20) {
        odabranaPloca = 3;
        debounce.reset();
        vrijemeZaIzborSnage.attach(this, &Kuhalo::ponistiOdabirPloce, 5);
    }
}

void Kuhalo::odabirPloce4() {
    if (debounce.read_ms() > 20) {
        odabranaPloca = 4;
        debounce.reset();
        vrijemeZaIzborSnage.attach(this, &Kuhalo::ponistiOdabirPloce, 5);
    }
}

void Kuhalo::izborSnage() {
    if (debounce.read_ms() > 20) {
        debounce.reset();
        //vrijemeZaIzborSnage.detach();
        vrijemeZaIzborSnage.attach(this, &Kuhalo::ponistiOdabirPloce, 5);
        odabranaSnaga = ++odabranaSnaga % 5;
        float snaga = (float) odabranaSnaga / 4;
        switch(odabranaPloca) {
            case 1:
                ploca1 = snaga;
                break;
            case 2:
                ploca2 = snaga;
                break;
            case 3:
                ploca3 = snaga;
                break;
            case 4:
                ploca4 = snaga;
                break;
        }
    }
}

void Kuhalo::ponistiOdabirPloce() {
    odabranaPloca = 0;
    odabranaSnaga = 0;
}