#ifndef HEATER_H
#define HEATER_H

#include "mbed.h"

/** A simple class for temperature control in the room using
 * a heater driven via digital output and one analog temperature sensor.
 *
 * Author(s): TVZ Mechatronics Team
 *
 */
class Heater {
    public:
        /** Constructor receives pin names of the temperature sensor and
         * the DigitalOut pin to which the heater driver is connected. */
        Heater(PinName sensorPin, PinName digitalOutPin);
        /** Set the temperature range of the sensor. */
        void configureSensor(float minTemperature, float maxTemperature);
        /** Read the current room temperature from the sensor. */
        float readTemperature();
        /** Test if the heater in turned ON. */
        bool isHeaterOn();
        /** Set the desired room temperature. */
        void setTemperature(float temp);
    private:
        AnalogIn sensor;
        DigitalOut driver;
        Ticker ticker;
        void regulateTemperature();
        bool heaterOn;
        float currentTemp, desiredTemp, minTemp, maxTemp, hysteresis, heaterOnTemp, heaterOffTemp;
};

#endif // HEATER_H