#include "Heater.h"

Heater::Heater(PinName sensorPin, PinName pwmoutPin): sensor(sensorPin), driver(pwmoutPin) {
    hysteresis = 0.5;
    heaterOn = false;
    configureSensor(5, 30);
    setTemperature(22);
    ticker.attach(this, &Heater::regulateTemperature, 1);
}

void Heater::configureSensor(float minTemperature, float maxTemperature) {
    if (minTemperature < maxTemperature) {
        minTemp = minTemperature;
        maxTemp = maxTemperature;
    }
}

float Heater::readTemperature() {
    return (maxTemp - minTemp) * sensor.read() + minTemp;
}

bool Heater::isHeaterOn() {
    return heaterOn;
}

void Heater::setTemperature(float temp) {
    if (temp >= minTemp && temp <= maxTemp) {
        desiredTemp = temp;
        heaterOnTemp = desiredTemp - hysteresis / 2;
        heaterOffTemp = desiredTemp + hysteresis / 2;
    }
}

void Heater::regulateTemperature() {
    currentTemp = readTemperature();
    if (currentTemp < heaterOnTemp && !isHeaterOn())
        driver = 1; // turn ON the heater
    else if (currentTemp > heaterOffTemp && isHeaterOn()) 
        driver = 0; // turn OFF the heater
    heaterOn = driver.read();
}