#include "mbed.h"
#include "Flash.h"

BusOut display(LED1, LED2, LED3, LED4);
InterruptIn cntUp(p5);
Timer debounceUp;
Flash flash;

char retainData[MEM_SIZE];
uint8_t counter;

void countUp(void) {
    if (debounceUp.read_ms() > 500) {
        
        if (counter > 15)
            counter = 0;
        else
            counter++;
            
        retainData[0] = counter;
        flash.writeFlash(retainData);
        
        debounceUp.reset();
    }
}

int main() {
    cntUp.rise(&countUp);
    debounceUp.start();
    
    flash.readFlash(retainData);
    counter = retainData[0];
    
    while(1) {
        display = counter;
    }
}
