#ifndef _FLASH_H_MB_
#define _FLASH_H_MB_

#include "mbed.h"
#include "IAP.h"

// Data for NXP LPC1768 from data table which is explained in datasheet UM10360 page 626.
#define MEM_SIZE 256
#define TARGET_SECTOR 29

/** This is simple library for storing data to flash memory and
 * reading it. This allows us to have retain data without having to have  
 * external flash chip. This class uses NXP LPC1768 internal flash memory
 * which give us 256B of flash size.
 * 
 * Author: TVZ Mechatronics Team
 *
 * Example of use:
 * @code
 * #include "mbed.h"
 * #include "Flash.h"
 *
 * BusOut display(LED1, LED2, LED3, LED4);
 * InterruptIn cntUp(p5);
 * Timer debounceUp;
 * Flash flash;
 *
 * char retainData[MEM_SIZE];
 * uint8_t counter;
 *
 * void countUp(void) {
 *    if (debounceUp.read_ms() > 500) {
 *        if (counter > 15)
 *            counter = 0;
 *        else
 *            counter++;
 *            
 *        retainData[0] = counter;
 *        flash.writeFlash(retainData);
 *        
 *        debounceUp.reset();
 *    }
 * }
 * 
 * int main() {
 *    cntUp.rise(&countUp);
 *    debounceUp.start();
 *
 *    flash.readFlash(retainData);
 *    counter = retainData[0];
 *
 *    while(1) {
 *        display = counter;
 *    }
 * }
 * @endcode
 */
class Flash {
    public:
        /** Constructor */
        Flash();
        /** Function recevies data array wich is stored in flash memory */
        void writeFlash(char data[MEM_SIZE]);
        /** Function returning data to pointer to array of size 256 wich is stored in flash memory */
        void readFlash(char *data);
    private:
        IAP iap;
};

#endif