#include "Flash.h"

Flash::Flash() {

}

void Flash::writeFlash(char data[MEM_SIZE]) {
    __disable_irq();
    
    // varijabla za spremanje odgovora
    int r;  
    // provijera ako je sektor flasha prazan, nakon svakog novog programiranja se flash prazni
    r = iap.blank_check(TARGET_SECTOR, TARGET_SECTOR);
    // brisanje sektora ako je potrebno
    if (r == SECTOR_NOT_BLANK) {
        iap.prepare(TARGET_SECTOR, TARGET_SECTOR);
        r = iap.erase(TARGET_SECTOR, TARGET_SECTOR);
    }
    // pisanje podataka u memoriju
    iap.prepare(TARGET_SECTOR, TARGET_SECTOR);
    iap.write(data, sector_start_adress[TARGET_SECTOR], MEM_SIZE);
    
    __enable_irq();
}

void Flash::readFlash(char *data) {
    __disable_irq();
    
    memcpy(data, sector_start_adress[TARGET_SECTOR], MEM_SIZE);
    
    __enable_irq();
}