#include "DRV8301.h"
#include "mbed.h"

/** Primjer konstruktora s fiksno oređenim pinovima */
DRV8301::DRV8301() : spi(p11, p12, p13), cs(p8), en_gate(p14) {
    startup();  //nužno izvršiti za slučaj da se u dosadašnjem radu pojavila pogreška, resetira cijeli DRV8301 te gasi sve dojave grešaka osim ukoliko su još uvijek prisutne
}

DRV8301::DRV8301(PinName pcs, PinName pmosi, PinName pmiso, PinName psck, PinName pen_gate) : spi(pmosi, pmiso, psck), cs(pcs), en_gate(pen_gate) {
    startup();  //nužno izvršiti za slučaj da se u dosadašnjem radu pojavila pogreška, resetira cijeli DRV8301 te gasi sve dojave grešaka osim ukoliko su još uvijek prisutne
}

//funkcija za pokretanje (reboot) DRV-a
void DRV8301::startup() {
    spi.format(16,1);           //format SPI komunikacije: 16-bitne riječi, mod 1 clocka
    spi.frequency(1000000);     //frekvencija clocka 1MHz
    cs = 1;
    cs = 0; 
    en_gate = 0;    //postavlja EN_GATE pin predupravljača u 0 čime gasi cijeli predupravljač
    wait_us (25);   //čekanje od 25 mikrosekundi kako bi se izbjeglo blokiranje predupravljača --> pozovite se na stranicu datasheeta
    en_gate = 1;    //postavlja EN_GATE pin u 1 čime pokreće predupravljač
    wait (1);   //čekanje od 1 sekunde // zašto treba ovo čekanje od 1 sekunde?
    
    /* ne bi bilo loše pročitati inicijalna stanja registara */
}

//funkcija za ograničenje struje
void DRV8301::setCurrentLimit(uint8_t inputCL){
    /* ovdje bi trebali provjeriti da li je broj u rasponu od 0 do 31 */
    controlRegister1 = spi.write(0x9000);   //čita stanje kontrolnog registra 1 i sprema ga u varijablu controlRegister1 // nije potrebna još jedna lokalna varijabla funkcije
    int maskCurrentLimit = 0x783F;          //maska koja postavlja bitove za postavljanje ograničenja (bitovi D6, D7, D8, D9, D10 kontrolnog registra 1; datasheet) struje u 0 ne mijenjajući pritome ostale
    controlRegister1 &= maskCurrentLimit;   //provodi logičku I operaciju po bitovima između stanja registra i maske te sprema rezultat u varijablu controlRegister1
    controlRegister1 |= inputCL << 6;       //uneseni broj input u binarnom obliku pomiče za 6 mjesta ulijevo kako bi se postavili na pravo mjesto u registru, provodi logičku ILI operaciju s varijablom  controlRegister1 te rezultat sprema
    spi.write(controlRegister1);            //upisuje varijablu controlRegister1 u kontrolni registar 1 // da li ste provjerili da li se kod čitanja registra MSB vraća u 0?
}
 
//funkcija za broj PWM ulaza
void DRV8301::setPWMNumber(uint8_t inputPWMNumber){
    /* provjera raspona inputPWMNumber */
    uint16_t controlRegister1 = spi.write(0x9000);  //čita stanje kontrolnog registra 1 i sprema ga u varijablu controlRegister1
    int maskPWM = 0x7FF7;                       //maska koja postavlja bitove registra zadužene za odabir broja PWM signala (bit D3 kontrolnog registra 1; datasheet) u 0 ne mijenjajući pritome ostale
    controlRegister1 &= maskPWM;            //provodi logičku I operaciju po bitovima između stanja registra i maske te sprema rezultat u varijablu controlRegister1
    controlRegister1 |= inputPWMNumber << 3;         //uneseni broj input u binarnom obliku pomiče za 3 mjesta ulijevo kako bi se postavili na pravo mjesto u registru, provodi logičku ILI operaciju s varijablom  controlRegister1 te rezultat sprema
    spi.write(controlRegister1);            //upisuje varijablu controlRegister1 u kontrolni registar 1
}
    
//funkcija za mod OCP-a

void DRV8301::setOCPMode(uint8_t inputOCPMode){
    /* provjera raspona inputOCPMode */
    uint16_t controlRegister1 = spi.write(0x9000);  //čita stanje kontrolnog registra 1 i sprema ga u varijablu controlRegister1
    int maskOCP = 0x7FCF;                       //maska koja postavlja bitove registra zadužene za odabir moda OCP-a (bitovi D4 i D5 kontrolnog registra 1; datasheet) u 0 ne mijenjajući pritome ostale
    controlRegister1 &= maskOCP;            //provodi logičku I operaciju po bitovima između stanja registra i maske te sprema rezultat u varijablu controlRegister1
    controlRegister1 |= inputOCPMode << 4;         //uneseni broj input u binarnom obliku pomiče za 4 mjesta ulijevo kako bi se postavili na pravo mjesto u registru, provodi logičku ILI operaciju s varijablom  controlRegister1 te rezultat sprema
    spi.write(controlRegister1);            //upisuje varijablu controlRegister1 u kontrolni registar 1
}

//funkcija za mod OCTW-a 

void DRV8301::setOCTW(uint8_t inputOCTWMode){
    /* provjera raspona  */
    uint16_t controlRegister2 = spi.write(0x9800);  //čita stanje kontrolnog registra 2 i sprema ga u varijablu controlRegister2
    int maskOCTW = 0x7FFC;                      //maska koja postavlja bitove registra zadužene za odabir moda OCTW-a (bitovi D0 i D1 kontrolnog registra 2; datasheet) u 0 ne mijenjajući pritome ostale
    controlRegister2 &= maskOCTW;           //provodi logičku I operaciju po bitovima između stanja registra i maske te sprema rezultat u varijablu controlRegister2
    controlRegister2 |= inputOCTWMode;              //s unesenim brojem input u binarnom obliku provodi logičku ILI operaciju s varijablom  controlRegister2 te rezultat sprema
    spi.write(controlRegister2);            //upisuje varijablu controlRegister2 u kontrolni registar 2
}
    
//funkcija za pojačanje

void DRV8301::setGain(uint8_t inputGain){
    /* provjera raspona  */
    uint16_t controlRegister2 = spi.write(0x9800);  //čita stanje kontrolnog registra 2 i sprema ga u varijablu controlRegister2
    int maskGain = 0x7FF3;                      //maska koja postavlja bitove registra zadužene za odabir iznosa pojačanja (bitovi D2 i D3 kontrolnog registra 2; datasheet) u 0 ne mijenjajući pritome ostale
    controlRegister2 &= maskGain;           //provodi logičku I operaciju po bitovima između stanja registra i maske te sprema rezultat u varijablu controlRegister2
    controlRegister2 |= inputGain << 2;         //uneseni broj input u binarnom obliku pomiče za 2 mjesta ulijevo kako bi se postavili na pravo mjesto u registru, provodi logičku ILI operaciju s varijablom  controlRegister2 te rezultat sprema
    spi.write(controlRegister2);            //upisuje varijablu controlRegister2 u kontrolni registar 2
}

//funkcija za dobivanje stanja u registru 1

uint16_t DRV8301::getControlRegister1(){
    controlRegister1 = spi.write(0x9000);  //šalje naredbu za čitanje u kontrolni registar 1 te dobiva odgovor kojega posprema u varijablu controlRegister1
    return controlRegister1;
}
   
// funkcija za dobivanje stanja u registru 2

uint16_t DRV8301::getControlRegister2(){
    controlRegister2 = spi.write(0x9800);  //šalje naredbu za čitanje u kontrolni registar 2 te dobiva odgovor kojega posprema u varijablu controlRegister2
    return controlRegister2;
}

//funkcija za čitanje statusnog registra 1

uint16_t DRV8301::getStatusRegister1(){
    statusRegister1 = spi.write(0x8000);   //šalje naredbu za čitanje u statusni registar 1 te dobiva odgovorkojega posprema u varijablu statusRegister1
    return statusRegister1;
}

//funkcija za čitanje statusnog registra 2

uint16_t DRV8301::getStatusRegister2(){
    statusRegister2 = spi.write(0x8800);   //šalje naredbu za čitanje u statusni registar 2 te dobiva odgovorkojega posprema u varijablu statusRegister2
    return statusRegister2;
}

//funkcija za ograničenje struje gate-a internog MOSFET-a

void DRV8301::setGateCurrent(uint8_t inputGateCurrent){
    /* provjera raspona inputGateCurrent */
    controlRegister1 = spi.write(0x9000);  //čita stanje kontrolnog registra 1 i sprema ga u varijablu controlRegister1
    int maskGateCurrent = 0x7FFC;   //maska koja postavlja bitove registra zadužene za odabir struje gate-a (bitovi D0 i D1 kontrolnog registra 1; datasheet) u 0 ne mijenjajući pritome ostale
    controlRegister1 &= maskGateCurrent; //provodi logičku I operaciju po bitovima između stanja registra i maske te sprema rezultat u varijablu controlRegister1
    controlRegister1 |= inputGateCurrent;   //s unesenim brojem inputGateCurrent u binarnom obliku provodi logičku ILI operaciju s varijablom  controlRegister1 te rezultat sprema
    spi.write(controlRegister1);    //upisuje varijablu controlRegister1 u kontrolni registar 1
}