#include "mbed.h"
#include "CurrentRegulation.h"
#include "PI.h"

Serial pc(USBTX, USBRX);
CurrentRegulation cr(p17, p18, p19, p20);

int main() {    
    double K_R;
    double T_I = 1.428e-3;
    double T_d  = 500e-6;
    while(true) {
      double I_Ar = cr.showResult();
      pc.printf("Current phase A: %f\n\r", I_Ar);  
      K_R = cr.calculateKr();
      PI reg(K_R, T_I, T_d);
      double in = pc.getc();
      double u = in - I_Ar;
      reg.in(u);
    }  
}





/*
#include "mbed.h"
#include "CurrentMeasurement.h"

Serial pc(USBTX, USBRX);

int main(){
    CurrentMeasurement c(p17, p18, p19, p20);
    while(true){
        pc.printf("Current phase A: %f\n\r", c.calculateCurrentA());
        pc.printf("Current phase B: %f\n\r", c.calculateCurrentB()); 
        pc.printf("Current phase C: %f\n\r", c.calculateCurrentC()); 
        pc.printf("Total Current: %f\n\r", c.calculateCurrentTotal()); 
        wait_ms(1);       
    }
}
*/

/*
#include "mbed.h"

AnalogIn gas(p16);
AnalogIn I_A(p17);
AnalogIn I_B(p18);
AnalogIn I_C(p19);
AnalogIn I_TOTAL(p20);

Serial pc(USBTX, USBRX);

int main() {
    float R_sh = 1e-3;
    float R_1s = 1e3;
    float R_1t = 1e3;
    float R_fs = 40e3;
    float R_ft = 20e3;
    float V_ref = 3.3;
    float I_A_, I_B_, I_C_, I_TOTAL_;
    while(1) {
        I_A_ = (R_sh * R_1s * (V_ref * I_A.read()))/R_fs - (R_sh * R_1s * (V_ref/2))/R_fs;
        I_B_ = (R_sh * R_1s * (V_ref * I_B.read()))/R_fs - (R_sh * R_1s * (V_ref/2))/R_fs;
        I_C_ = (R_sh * R_1s * (V_ref * I_C.read()))/R_fs - (R_sh * R_1s * (V_ref/2))/R_fs;
        I_TOTAL_ = (R_1t * (V_ref * I_TOTAL.read()))/(R_ft * R_sh) - (R_1t * (V_ref/2))/(R_ft * R_sh);
        pc.printf("Current phase A: %f\n\r", I_A_);
        pc.printf("Current phase B: %f\n\r", I_B_);
        pc.printf("Current phase C: %f\n\r", I_C_);
        pc.printf("Total Current: %f\n\r", I_TOTAL_);
        wait_ms(1);
    }
}
*/