#include "mbed.h"
#include "C12832.h"
#include "Bomba.h"

Bomba::Bomba(PinName aktivirajPin) : aktiviraj(aktivirajPin), lcd(p5, p7, p6, p8, p11), buzz(p26) {
    aktiviran = false;
    aktiviraj.rise(this, &Bomba::aktivacija);
    debounce.start();
    buzz = 0;
    buzz.period(1.0f/1e3);
    x = 5;
    lcd.cls();
    lcd.locate(0,3);
    lcd.printf("PURS_ZI_003\nAktiviraj bombu!");
}

void Bomba::aktivacija() {
    if(debounce.read_ms() > 200) {
        if (!aktiviran) {
            detoniraj.attach(this, &Bomba::detonacija, x);
            aktiviran = true;
            lcd.cls();
            lcd.locate(0,3);
            lcd.printf("Bomba aktivirana");
        } else {
            detoniraj.detach();
            buzz = 0;
            aktiviran = false;
            lcd.cls();
            lcd.locate(0,3);
            lcd.printf("Bomba deaktivirana");
        }
        debounce.reset();
    }
}

void Bomba::detonacija() {
    buzz = 0.5;
    lcd.cls();
    lcd.locate(0,3);
    lcd.printf("Boom!!!");
}