#ifndef MBED_BLINKER_H_TB
#define MBED_BLINKER_H_TB

#include "mbed.h"

/** Simple class for learning development of libraries. The main task
 *  is to blink (flash) a LED connected to a specified pin N times. 
 * Each blink should last 0.5 seconds by default, or some other time
 * that user can set.
 * 
 * Author: TVZ Mechatronics Team
 *
 * Example of use:
 * @code
 * #include "mbed.h"
 * #include "Blinker.h"
 *
 * int main() {
 *    Blinker myBlinker(LED3);
 *    myBlinker.blink(10);
 *    while(!myBlinker.isFinished()) {
 *        // do something else...
 *    }
 *    myBlinker.blink(5, 1);
 *    while(!myBlinker.isFinished()) {
 *        // do something else...
 *    }
 * }
 * @endcode
 */
class Blinker {

public:

    /** Constructor receives a pin name that LED is connected to. */
    Blinker(PinName pin);

    /** Function recevies number of blinks (flashes) and a time of duration of each blink. */
    void blink(int n, float t = 0.5);
    
    /** Checks if the blinking is finished. 
     * @returns true if the complete process is finished, false otherwise.
     */
    bool isFinished();

private:

    DigitalOut myled;
    int i, N;
    float period;
    Ticker ticker;
    Timeout timeout;
    bool finished, almostFinished;
    void turnLedOff();
    void turnLedOn();
    void done();
};

#endif