#include "Blinker.h"
#include "mbed.h"

Blinker::Blinker(PinName pin):myled(pin) {
    myled = 0;
    i = 0;
    N = 0;
    period = 0;
}

void Blinker::blink(int n, float t) {
    finished = false;
    almostFinished = false;
    i = 0;
    if (i < n) {
        myled = 1;
        timeout.attach(this, &Blinker::turnLedOff, t/2);
        N = n;
        period = t;
        i++;
        if (i < N) {
            ticker.attach(this, &Blinker::turnLedOn, t);
        } else {
            almostFinished = true;
        }
    } else {
        finished = true;
    }
}

void Blinker::turnLedOff() {
    myled = 0;
    if (almostFinished) {
        timeout.attach(this, &Blinker::done, period/2);
    }
}

void Blinker::turnLedOn() {
    myled = 1;
    timeout.attach(this, &Blinker::turnLedOff, period/2);
    if (++i >= N) {
        ticker.detach();
        almostFinished = true;
    }
}
void Blinker::done() {
    finished = true;
}

bool Blinker::isFinished() {
    return finished;
}