#ifndef PT1_H
#define PT1_H

#include "mbed.h"

/** Transfer function of a PT1 form.
 * G(s) = Y(s) / U(s) = K / (1 + T_1 s)
 *
 * Author(s): TVZ Mechatronics Team
 *
 */
class PT1 {
    public:
        /** Default constructor.
         * K = 1, T_1 = 1, sampleTime = 0.1
         */
        PT1();
        /** PT1 transfer function parameters and sample time in seconds. */
        PT1(double K, double T_1, double sampleTime);
        /** Update PT1 transfer function parameters and sample time. */
        void setParameters(double K, double T_1, double sampleTime);
        /** Calculate the output y. */
        double out();
        /** Set the input u. */
        void in(double u);
    private:
        double K, T_1, T_d, a_1, b_1, y, y_p1, u, u_p1;
};

#endif // PT1_H