#include "PI.h"

PI::PI() {
    u = y = u_p1 = y_p1 = 0;
    setParameters(1, 1, 0.1);
    setOutputLimits(0, 1);
    setOperationMode(automatic);
}

PI::PI(double K_R_, double T_I_, double T_d_) {
    u = y = u_p1 = y_p1 = 0;
    setParameters(K_R_, T_I_, T_d_);
    setOutputLimits(0, 1);
    setOperationMode(automatic);
}

void PI::setParameters(double K_R_, double T_I_, double T_d_) {
    if (T_d_ > 0)
        T_d = T_d_;
    else
        T_d = 0.1;
    if (T_I_ > 0)
        T_I = T_I_;
    else
        T_I = 1;
    K_R = K_R_;
}

void PI::setOutputLimits(double lowerOutputLimit, double upperOutputLimit) {
    if (upperOutputLimit > lowerOutputLimit) {
        y_min = lowerOutputLimit;
        y_max = upperOutputLimit;
    }
}

void PI::setOperationMode(Mode newOperationMode) {
    // Bumpless transfer from manual to automatic mode
    if (operationMode == manual && newOperationMode == automatic) {
        y = y_p1 = y_manual;
        u = u_p1 = 0;
    }
    // Bumpless transfer from automatic to manual mode
    else if (operationMode == automatic && newOperationMode == manual) {
        y_manual = y;
    }
    operationMode = newOperationMode;
}

void PI::setOutputManually(double u_C) {
    y_manual = u_C;
}

double PI::out() {
    if (operationMode == automatic) {
        y = y_p1 + K_R * u + K_R * (T_d / T_I - 1) * u_p1;
    } else if (operationMode == manual) {
        y = y_manual;
    }
    
    if (y > y_max)
        y = y_max;
    else if (y < y_min)
        y = y_min;
    
    y_p1 = y;    
    u_p1 = u;
    return y;
}

void PI::in(double u_) {
    u = u_;
}