#include "PT2.h"

PT2::PT2() {
    u = y = u_p1 = y_p1 = u_p2 = y_p2 = 0;
    setParameters(1, 1, 0.5, 0.1);
}

PT2::PT2(double K_, double T_1_, double T_2_, double T_d_) {
    u = y = u_p1 = y_p1 = u_p2 = y_p2 = 0;
    setParameters(K_, T_1_, T_2_, T_d_);
}

void PT2::setParameters(double K_, double T_1_, double T_2_, double T_d_) {
    if (T_d_ > 0)
        T_d = T_d_;
    else
        T_d = 0.1;
    K = K_;
    T_1 = T_1_;
    T_2 = T_2_;
    a = 1 / T_1;
    b = 1 / T_2;
    c = exp(-a * T_d);
    d = exp(-b * T_d);
    b_1 = -K * ( (a - b)*(c + d) + b*(1 + d) - a*(1 + c) ) / (a - b);
    b_2 = K * ( (a - b)*c*d + b*d - a*c ) / (a - b);
    a_1 = -(c + d);
    a_2 = c*d;
}

double PT2::out() {
    y = -a_1 * y_p1 - a_2 * y_p2 + b_1 * u_p1 + b_2 * u_p2;
    y_p2 = y_p1;
    y_p1 = y;   
    u_p2 = u_p1; 
    u_p1 = u;
    return y;
}

void PT2::in(double u_) {
    u = u_;
}