#include "PT1.h"

PT1::PT1() {
    u = y = u_p1 = y_p1 = 0;
    setParameters(1, 1, 0.1);
}

PT1::PT1(double K_, double T_1_, double T_d_) {
    u = y = u_p1 = y_p1 = 0;
    setParameters(K_, T_1_, T_d_);
}

void PT1::setParameters(double K_, double T_1_, double T_d_) {
    if (T_d_ > 0)
        T_d = T_d_;
    else
        T_d = 0.1;
    K = K_;
    T_1 = T_1_;
    a_1 = -exp(-T_d/T_1);
    b_1 = K * (1 + a_1);    
}

double PT1::out() {
    y = -a_1 * y_p1 + b_1 * u_p1;
    y_p1 = y;    
    u_p1 = u;
    return y;
}

void PT1::in(double u_) {
    u = u_;
}