#include "I.h"

I::I() {
    u = y = u_p1 = y_p1 = 0;
    setParameters(1, 0.1);
}

I::I(double K_I_, double T_d_) {
    u = y = u_p1 = y_p1 = 0;
    setParameters(K_I_, T_d_);
}

void I::setParameters(double K_I_, double T_d_) {
    if (T_d_ > 0)
        T_d = T_d_;
    else
        T_d = 0.1;
    K_I = K_I_;
}

double I::out() {
    y = y_p1 + K_I * T_d * u_p1;
    y_p1 = y;    
    u_p1 = u;
    return y;
}

void I::in(double u_) {
    u = u_;
}