#include "mbed.h"
#include "Display1602.h"


I2C MSP430G( p9, p10);
Serial pc(USBTX, USBRX);
Display1602 display(p19, p20, p21, p22, p23, p24,p25,p26,p29,p30,p18); 


const int addr0 = 0x94;
const int addr1 = 0x94; 
char config_t[2];  
char config_v[2];                  // transmitt buffer 
char temp_read[2];
char volt_read[2];                   //  read buffer 
float temp, Uin;

int main()
{
    while(1) 
    { 
        config_v[0] = 0xC1;                 //config slave to Ain      
        config_v[1] = 0xff; 
        //MSP430G.stop();
        //MSP430G.stop();
        wait_us(200);                  // config data byte1, BOut      
        MSP430G.write(addr0, config_v,2); 
        //MSP430G.stop();          
        wait_us(200);       
        MSP430G.read(addr0, volt_read, 2);   //read the two-byte temp data      
        float Uin = volt_read[0]+volt_read[1]*256;     
        Uin = Uin/1023;        
        pc.printf("Ain = %.4f V\n\r", Uin*1.5);  // print on screen 
        //MSP430G.stop();
         
        wait(5);
        
        
        
        config_t[0] = 0xC0;                 //config slave to int temp        
        config_t[1] = 0x55;  
        //MSP430G.stop();
        wait_us(200);                 
        MSP430G.write(addr1, config_t, 2);
        //MSP430G.stop();   
        wait_us(200);
        MSP430G.read(addr1, temp_read, 2);   //read the two-byte temp data  
        float temp = temp_read[0]+temp_read[1]*256;        
        pc.printf("Temp = %.1f degC\n\r", temp/10);  // print on screen   
        //MSP430G.stop();      
        wait(5);    
        
    }
}
