#include "mbed.h"
 
Ticker osvjezavanje;                                
Serial pc(USBTX, USBRX);                           
DigitalOut trig (p29);                              
DigitalIn  echo (p30);                              
PwmOut led(p21);
int alarm;
BusInOut inputSW(p24, p25, p26, p27);               
DigitalOut Dis1(p19);                               
DigitalOut Dis2(p20);                               
BusOut Seg(p5,p6,p7,p8,p9,p10,p11,p12);             
int prikaz;
int Znak1;
int Znak2;
int brojac;
Timer tmr;                                          
double pulsedur, distance;                          
char SegConvert(char SegValue);                     
void displays();
  
int main()
{
    inputSW.mode(PullUp);                           
    led.period(0.001);
    osvjezavanje.attach(&displays, 0.005);          
    while(1) {
        tmr.reset();                                
        trig = 1;                                   
        wait_us(10);                                
        trig = 0;                                   
 
        while (!echo);                              
        tmr.start();
 
        while (echo);                               
        tmr.stop();
 
        pulsedur = tmr.read_us();                   
        distance = pulsedur/58;                     
        pc.printf("pulsedur=%8.2f\n\r", distance);  
        switch(inputSW) {                           
            case 0x1:
                alarm=4;
                break;
            case 0x2:
                alarm=6;
                break;
            case 0x3:
                alarm=8;
                break;
            case 0x4:
                alarm=10;
                break;
            case 0x5:
                alarm=12;
                break;
            case 0x6:
                alarm=14;
                break;
            case 0x7:
                alarm=16;
                break;
            case 0x8:
                alarm=18;
                break;
            case 0x9:
                alarm=20;
                break;
            case 0xA:
                alarm=22;
                break;
            case 0xB:
                alarm=24;
                break;
            case 0xC:
                alarm=26;
                break;
            case 0xD:
                alarm=28;
                break;
            case 0xE:
                alarm=30;
                break;
            case 0xF:
                alarm=32;
                break;
            default :
                alarm=2;
        }
        if (alarm>distance) {
            led=0.5;
        } else {
            led=0.0;
        }
        prikaz = distance*100;                      
        Znak1 = prikaz/1000;                        
        Znak2 = (prikaz/100)%10;                    
        wait(0.5);
    }
}

void displays(){
    switch (++brojac) {                             
        case 1:                                     
            Dis1=1;                                 
            Dis2=0;                                 
            Seg=SegConvert(Znak1);                  
            break;
        case 2:                                     
            Dis1=0;                                 
            Dis2=1;                                 
            Seg=SegConvert(Znak2);                  
            brojac=0;                               
            break;
    }
}
 
char SegConvert(char SegValue){
    char SegByte=0x00;
    switch (SegValue) {                             
        case 0 :
            SegByte = 0x3F;                         
            break;                                  
        case 1 :
            SegByte = 0x06;                         
            break; 
        case 2 :
            SegByte = 0x5B;                         
            break; 
        case 3 :
            SegByte = 0x4F;                         
            break; 
        case 4 :
            SegByte = 0x66;                         
            break; 
        case 5 :
            SegByte = 0x6D;                         
            break; 
        case 6 :
            SegByte = 0x7D;                         
            break; 
        case 7 :
            SegByte = 0x07;                         
            break; 
        case 8 :
            SegByte = 0x7F;                         
            break; 
        case 9 :
            SegByte = 0x6F;                         
            break; 
    }
    return SegByte;
}