#include "mbed.h"

Serial pc(USBTX,USBRX);
I2C msp430(p28,p27);

const int adresa0 = 0x90;   //i2c adresa prvog MSP430 mikroupravljaca - desetice
const int adresa1 = 0x92;   //i2c adresa drugog MSP430 mikroupravljaca - jedinice
char byte_1[2]= {0xC2,0x00};
char byte_2[2]= {0xC2,0x00};
char temp_read[2];         //char varijabla u koju se spremaju podaci poslani sa MSP430 - dummy
char ispis(int x);         //funkcija prima int broj i vraća hex vrijedost koja se salje u MSP430 kako bi se prikazao određeni broj
char temp_broj;       
int broj_int=0;
char mod_temp;
void msp430_write(int);    //ispis pojedinacne znamenke na 7-seg display preko i2c veze    
void count();              //brojanje od 0-99 
int upute=1;
DigitalOut reset(p30);     //reset msp430 nakon svake znamenke
DigitalOut led(p10);       //ledica blinka nakon ispisa nove znamenke
Ticker timer;
void random();              //generiranje slucajnog broja u rasponu 0-99
int main()
{
    while(1) {
        if(upute<2) {
            pc.printf("Unesi mod rada \r\n");
            pc.printf("Za brojanje od 0 do 99 unesi slovo 's' \r\n");
            pc.printf("Za ispis random broja unesi slovo 'r' \r\n");
            upute++;
            reset=1;
        }
    
    if(pc.readable()) {               //ako postoji podatak na i2c sabirnici
            mod_temp =pc.getc();}      //spremi slovo u varijablu mod_temp

        switch (mod_temp) {             
            case 's':                   // slovo s pokreni brojanje 0-99
                timer.attach(&count,1); //pokreni ticker-timer u intervalu 1 sekunde,poziva funkciju count svake sekunde
                break;

            case 'r':                   //slovo r ispis random broja
                timer.detach();           
                random();
                break;
            
            default:
            
            }
            
    }
}

void random ()
{
    int rand_num=rand()%100;
    msp430_write(rand_num);
}

void count()
{
    led=1;
    if(broj_int<99) broj_int++;
    else broj_int=0;
    msp430_write(broj_int);
    led=0;
}

void msp430_write(int x)
{

    int num_jedinica = x/10;            //varijabla za pohranu vrijednosti jedinice
    int num_desetica = x%10;            //varijabla za pohranu vrijednosti desetice
    char jedinica = ispis(num_jedinica);
    char desetica = ispis(num_desetica);
    byte_1[1]=desetica;
    byte_2[1]=jedinica;
    reset=0;
    wait_us(200);
    reset=1;
    wait_ms(2);
    msp430.write(adresa0,byte_1,2);
    wait_us(20);
    msp430.write(adresa1,byte_2,2);
    wait_us(20);
    msp430.read(adresa1, temp_read, 2);
    wait_us(20);
    msp430.read(adresa0, temp_read, 2);
    wait_us(20);


}

char ispis(int x)
{
    char num;
    switch (x) {

        case 0:
            num=0x3F; // '0'
            break;
        case 1:
            num=0x06; // '1'
            break;
        case 2:
            num=0x5B; // '2
            break;
        case 3:
            num=0x4F; // '3'
            break;
        case 4:
            num=0x66; // '4'
            break;
        case 5:
            num=0x6D; // '5'
            break;
        case 6:
            num=0x7D; // '6'
            break;
        case 7:
            num=0x07; // '7'
            break;
        case 8:
            num=0x7F; // '8'
            break;
        case 9:
            num=0x6F; // '9'
            break;
        default:
            num=0x00;
    }
    return num;

}

