#include "mbed.h"
#include "hcsr04.h"

Ticker osvjezavanje; // ticker koji ce sluziti za osvjezavanje prikaza na displeju

Serial pc(USBTX, USBRX);
Serial bluetooth(p13, p14);
HCSR04 senzor(p29,p30);
AnalogIn Ain(p20);
PwmOut buzzer(p25);
float ADCdata;
float temp;
float koeficijent;
float duljina;
int alarm;
BusInOut inputSW(p15, p16, p17, p18);
DigitalOut Dis1(p24); // display1
DigitalOut Dis2(p23); // display2
DigitalOut Dis3(p22); // display3
DigitalOut Dis4(p21); // display4
BusOut Seg(p5,p6,p7,p8,p9,p10,p11,p12); // A,B,C,D,E,F,G,DP
int prikaz;
int Znak1;
int Znak2;
int Znak3;
int Znak4;
int brojac;

char SegConvert(char SegValue); // function prototype

//funkcija za osvjezavanje ispisa na displejima svakih  5ms-koristi se tromost oka za prikaz
void displeji()   // displeji function
{
    switch (++brojac) { // brojac se uvecava za 1 i svaki puta kada se uveca, prebacuje ispis na sljedeci displej
        case 1:  // ispisivanje na prvi displej
            Dis4=0; //iskljucuje se ispis na 4 displeju
            Dis1=1; //ukljucuje se ispis na 1 displeju
            Seg=SegConvert(Znak1); // tens column
            break;
        case 2:  //ispoisivanje na drugi displej
            Dis1=0; //iskljucuje se ispis na 1 displeju
            Dis2=1; //ukljucuje se ispis na 2 displeju
            Seg=SegConvert(Znak2); // tens column
            Seg=Seg|0x80;  // napravljena OR funkcija nad prikazanim cijeli djelom broja gdje se ukljucuje i decimalna tocka
            break;
        case 3:  //ispisivanje na treci displej
            Dis2=0; //iskljucuje se ispis na 2 displeju
            Dis3=1; //ukljucuje se ispis na 3 displeju
            Seg=SegConvert(Znak3); // tens column
            break;
        case 4: //ispisivanje na cetvrti displej
            Dis3=0; //iskljucuje se ispis na 3displeju
            Dis4=1; //ukljucuje se ispis na 4 displeju
            Seg=SegConvert(Znak4); // tens column
            brojac=0;  // kod ispisa na zadnjem displeju resetira se brojac da prikaz opet pocne od prvog displeja
            break;
    }
}

int main()
{
    ADCdata=0.06;
    inputSW.mode(PullUp);
    buzzer.period(0.001);
    osvjezavanje.attach(&displeji, 0.005);  //funkcija tickera. Vrijeme osvjezavanja displeja 5ms-koristi se tromost oka za prikaz
    while(1) {
        ADCdata=(0.9*ADCdata)+(0.1*Ain);
        temp=ADCdata*303;
        duljina = senzor.udaljenost();
        koeficijent = (temp*0.6)+331;
//        duljina=duljina/343;
//        duljina = duljina* koeficijent;
        pc.printf("udaljenost u cm =%8.2f\n\r", duljina);
        bluetooth.printf("udaljenost u cm =%8.2f\n\r", duljina);
        switch(inputSW) {
            case 0x1:
                alarm=4;
                break;
            case 0x2:
                alarm=6;
                break;
            case 0x3:
                alarm=8;
                break;
            case 0x4:
                alarm=10;
                break;
            case 0x5:
                alarm=12;
                break;
            case 0x6:
                alarm=14;
                break;
            case 0x7:
                alarm=16;
                break;
            case 0x8:
                alarm=18;
                break;
            case 0x9:
                alarm=20;
                break;
            case 0xA:
                alarm=22;
                break;
            case 0xB:
                alarm=24;
                break;
            case 0xC:
                alarm=26;
                break;
            case 0xD:
                alarm=28;
                break;
            case 0xE:
                alarm=30;
                break;
            case 0xF:
                alarm=32;
                break;
            default :
                alarm=2;
        }
        if (alarm>duljina) {
            pc.printf("ALARM =%d\n\r", alarm);
            bluetooth.printf("ALARM =%d\n\r", alarm);
            buzzer=0.5;
        } else {
            buzzer=0.0;
        }
        prikaz = duljina*100; //preracunavanje float varijable u postotcima u integer varijablu u voltima radi ispisa
        Znak1 = prikaz/1000;  //racunanje cijelog djela broja za ispis
        Znak2 = (prikaz/100)%10;  //racunanje prve decimale za ispis
        Znak3 = (prikaz/10)%10;  //racunanje druge decimale za ispis
        Znak4 = prikaz%10;  //racunanje trece decimale za ispis
        wait(0.5);
    }
}

char SegConvert(char SegValue)   // function 'SegConvert'
{
    char SegByte=0x00;
    switch (SegValue) { //DPGFEDCBA
        case 0 :
            SegByte = 0x3F;
            break; // 00111111 binary
        case 1 :
            SegByte = 0x06;
            break; // 00000110 binary
        case 2 :
            SegByte = 0x5B;
            break; // 01011011 binary
        case 3 :
            SegByte = 0x4F;
            break; // 01001111 binary
        case 4 :
            SegByte = 0x66;
            break; // 01100110 binary
        case 5 :
            SegByte = 0x6D;
            break; // 01101101 binary
        case 6 :
            SegByte = 0x7D;
            break; // 01111101 binary
        case 7 :
            SegByte = 0x07;
            break; // 00000111 binary
        case 8 :
            SegByte = 0x7F;
            break; // 01111111 binary
        case 9 :
            SegByte = 0x6F;
            break; // 01101111 binary
    }
    return SegByte;
}