#include "mbed.h"

Ticker osvjezavanje; // ticker koji ce sluziti za osvjezavanje prikaza na displeju

Serial pc(USBTX, USBRX);
DigitalOut trig (p29);
DigitalIn  echo (p30);
PwmOut buzzer(p21);
int alarm;
BusInOut inputSW(p24, p25, p26, p27);
DigitalOut Dis1(p20); // display1
DigitalOut Dis2(p19); // display2
BusOut Seg(p5,p6,p7,p8,p9,p10,p11,p12); // A,B,C,D,E,F,G,DP
int prikaz;
int Znak1;
int Znak2;
int brojac;
Timer tmr;
double pulsedur, distance;


char SegConvert(char SegValue); // function prototype

//funkcija za osvjezavanje ispisa na displejima svakih  5ms-koristi se tromost oka za prikaz
void displeji()   // displeji function
{
    switch (++brojac) { // brojac se uvecava za 1 i svaki puta kada se uveca, prebacuje ispis na sljedeci displej
        case 1:  // ispisivanje na prvi displej
            Dis2=0; //iskljucuje se ispis na 4 displeju
            Dis1=1; //ukljucuje se ispis na 1 displeju
            Seg=SegConvert(Znak1); // tens column
            break;
        case 2:  //ispoisivanje na drugi displej
            Dis1=0; //iskljucuje se ispis na 1 displeju
            Dis2=1; //ukljucuje se ispis na 2 displeju
            Seg=SegConvert(Znak2); // tens column
            brojac=0;  // kod ispisa na zadnjem displeju resetira se brojac da prikaz opet pocne od prvog displeja
            break;
    }
}

int main()
{
    inputSW.mode(PullUp);
    buzzer.period(0.001);
    osvjezavanje.attach(&displeji, 0.005);  //funkcija tickera. Vrijeme osvjezavanja displeja 5ms-koristi se tromost oka za prikaz
    while(1) {
        tmr.reset();
        trig = 1;
        wait_us(10);
        trig = 0;
 
        while (!echo); // wait high
        tmr.start();
 
        while (echo);  // wait low
        tmr.stop();
 
        pulsedur = tmr.read_us();
        distance = pulsedur*0.017; //cm
        pc.printf("pulsedur=%8.2f\n\r", distance); 
        switch(inputSW) {
            case 0x1:
                alarm=4;
                break;
            case 0x2:
                alarm=6;
                break;
            case 0x3:
                alarm=8;
                break;
            case 0x4:
                alarm=10;
                break;
            case 0x5:
                alarm=12;
                break;
            case 0x6:
                alarm=14;
                break;
            case 0x7:
                alarm=16;
                break;
            case 0x8:
                alarm=18;
                break;
            case 0x9:
                alarm=20;
                break;
            case 0xA:
                alarm=22;
                break;
            case 0xB:
                alarm=24;
                break;
            case 0xC:
                alarm=26;
                break;
            case 0xD:
                alarm=28;
                break;
            case 0xE:
                alarm=30;
                break;
            case 0xF:
                alarm=32;
                break;
            default :
                alarm=2;
        }
        if (alarm>distance) {
            buzzer=0.5;
        } else {
            buzzer=0.0;
        }
        prikaz = distance*100; //preracunavanje float varijable u postotcima u integer varijablu u voltima radi ispisa
        Znak1 = prikaz/1000;  //racunanje cijelog djela broja za ispis
        Znak2 = (prikaz/100)%10;  //racunanje prve decimale za ispis
        wait(0.5);
    }
}

char SegConvert(char SegValue)   // function 'SegConvert'
{
    char SegByte=0x00;
    switch (SegValue) { //DPGFEDCBA
        case 0 :
            SegByte = 0x3F;
            break; // 00111111 binary
        case 1 :
            SegByte = 0x06;
            break; // 00000110 binary
        case 2 :
            SegByte = 0x5B;
            break; // 01011011 binary
        case 3 :
            SegByte = 0x4F;
            break; // 01001111 binary
        case 4 :
            SegByte = 0x66;
            break; // 01100110 binary
        case 5 :
            SegByte = 0x6D;
            break; // 01101101 binary
        case 6 :
            SegByte = 0x7D;
            break; // 01111101 binary
        case 7 :
            SegByte = 0x07;
            break; // 00000111 binary
        case 8 :
            SegByte = 0x7F;
            break; // 01111111 binary
        case 9 :
            SegByte = 0x6F;
            break; // 01101111 binary
    }
    return SegByte;
}
