/*
Zadatak 1 Vu metar sa 20 LED elemenata.
2 LED stripa svaki s 10 LED.        2 funkcije: pojedinačna LED, Rastuci niz LED
Matija Vučina   &   Juraj Meštrović
*/
#include "mbed.h"

BusOut LedStrip(p14,p13,p12,p11,p10,p9,p8,p7,p6,p5);
DigitalOut Strip1(p21);
DigitalOut Strip2(p22);
DigitalIn Din(p28);
AnalogIn Ain(p20);   //  analogni ulaz   izmedu 0.0 i 1.0 

void VuRastuci (float analog);
void VuPojedinacno (float analog);

int main()
{
    Din.mode(PullUp);
    Strip1=0;
    Strip2=0;

    while(1) {
        while(Din==1) {            
            VuPojedinacno(Ain);      //pojedinacno
        }

        while (Din==0) {            
            VuRastuci(Ain);          //rastuce
        }
    }
}


void VuRastuci (float analog)
{
    Strip1=0;
    Strip2=0;
    LedStrip = 0x0;

    int x = (analog*20);
    LedStrip = ~(0x3FF<<x);          //upali odgovarajuce izlaze
    Strip1=1;                        //upali prvu strip
    wait(0.01);

    Strip1=0;                         //ugasi prvi strip  
    LedStrip = 0x0;                   //reset izlaza

    if(x>10) {
        x=x-10;
        LedStrip = ~(0x3FF<<x);      //isti postupak samo za drugi strip
        Strip2=1;
        wait(0.01);
    }
}

void VuPojedinacno (float analog)
{
    
     Strip1=0;
     Strip2=0;
    
    int x = (analog*20);            
    
    if(x>0 && x<=10) {              // ako je izmedu 0 i 10 to je prvi led strip
        LedStrip = 0x1<<(x-1);      // upali prvi bit i pomakni ga na odgovarajuce mjesto
        Strip1=1;                   //upali strip 1
        wait(0.01);
        Strip1=0;                   //ugasi strip 1
    } else if(x>10 && x<=20) {
        LedStrip = 0x1<<(x-11);
        Strip2=1;                   //upali strip 2
        wait(0.01);
        Strip2=0;                   //ugasi strip 2
    } else {
        Strip1=0;
        Strip2=0;
    }
}