#include "mbed.h"
InterruptIn button(p30); // Interrupt on digital input p30
DigitalOut led1(LED1); // digital out to onboard LED1
Timer debounce; // define debounce timer
LocalFileSystem local("local"); // define local file system
void toggle(void); // function prototype

int main()
{
    debounce.start(); // start debounce timer
    button.rise(&toggle); // attach the toggle function to the rising edge
}
void toggle()   // perform toggle if debounce time has elapsed
{
    if (debounce.read_ms()>200) {
        led1=!led1; // toggle LED
        FILE* Logfile = fopen ("/local/log.txt","a"); // open file for appending
        fprintf(Logfile,"time=%.3fs: setting led=%d\n\r",debounce.read(),led1.read());
        fclose(Logfile); // close file
        debounce.reset(); // reset debounce timer
    }
}