void SegInit(void); // function to initialise 7-seg displays
void HostInit(void); // function to initialise the host terminal
char GetKeyInput(void); // function to get a keyboard input from the terminal
char SegConvert(char SegValue); // function to convert a number to a 7-segment byte
#include "mbed.h"
Serial pc(USBTX, USBRX); // comms to host PC
BusOut Seg1(p5,p6,p7,p8,p9,p10,p11,p12); // A,B,C,D,E,F,G,DP
BusOut Seg2(p13,p14,p15,p16,p17,p18,p19,p20); // A,B,C,D,E,F,G,DP
void SegInit(void); // function prototype
void HostInit(void); // function prototype
char GetKeyInput(void); // function prototype
char SegConvert(char SegValue); // function prototype
char data1, data2; // variable declarations
int main() { // main program
SegInit(); // call function to initialise the 7-seg displays
HostInit(); // call function to initialise the host terminal
while (1) { // infinite loop
data2 = GetKeyInput(); // call function to get 1st key press
Seg2=SegConvert(data2); // call function to convert and output
data1 = GetKeyInput(); // call function to get 2nd key press
Seg1=SegConvert(data1); // call function to convert and output
pc.printf(" "); // display spaces between 2 digit numbers
}
}
void SegInit(void) {
Seg1=SegConvert(0); // initialise to zero
Seg2=SegConvert(0); // initialise to zero
}
void HostInit(void) {
pc.printf("\n\rType two digit numbers to be displayed on the 7-seg display\n\r");
}
char GetKeyInput(void) {
char c = pc.getc(); // get keyboard data (note num. ascii range 0x30-0x39)
pc.printf("%c",c); // print ascii value to host PC terminal
return (c&0x0F); // return value as non-ascii (bitmask c with value 0x0F)
}
char SegConvert(char SegValue) { // function 'SegConvert'
char SegByte=0x00;
switch (SegValue) { //DPGFEDCBA
case 0 : SegByte = 0x3F;break; // 00111111 binary
case 1 : SegByte = 0x06;break; // 00000110 binary
case 2 : SegByte = 0x5B;break; // 01011011 binary
case 3 : SegByte = 0x4F;break; // 01001111 binary
case 4 : SegByte = 0x66;break; // 01100110 binary
case 5 : SegByte = 0x6D;break; // 01101101 binary
case 6 : SegByte = 0x7D;break; // 01111101 binary
case 7 : SegByte = 0x07;break; // 00000111 binary
case 8 : SegByte = 0x7F;break; // 01111111 binary
case 9 : SegByte = 0x6F;break; // 01101111 binary
}
return  SegByte;
}