/*
Kontrola ledica pomocu 4 prekidaca i funkcije BusInOut
link na handbook za BusInOut:
http://developer.mbed.org/handbook/BusInOut
*/
#include "mbed.h"

DigitalOut redled(p5);
DigitalOut greenled(p6);

BusInOut inputSW(p7, p8, p9, p10);

int main() {
    inputSW.mode(PullUp); // Pull up internal resistor
    while(1) {
        switch(inputSW) {
            case 0x1:
                greenled = 1; //green led is on
                redled = 0; //red led is off
                break;
            case 0x2:
                greenled = 0; //green led is off
                redled = 1; //red led is on
                break;
            case 0x4:
            case 0x8:
                greenled = 1; //green led is on
                redled = 1; //red led is on
                break;
            default :
                greenled = 0; //green led is off
                redled = 0; //red led is off
        }
    }
}