#include "mbed.h"

AnalogOut Aout(p18);
AnalogIn Ain(p20);
//AnalogIn Ain1(p19);
//AnalogIn Ain2(p20);

DigitalIn sw1(p7);
DigitalIn sw2(p8);
DigitalIn sw3(p9);
DigitalIn sw4(p10);

int main() {
    float A,T,f,Ts;//A=amplitude, T=period, f=frequency, Ts= sampling time
    const float PI=3.141592;
    int SinNumPoints=100;
    
    //with only one potenciometer
    while(1) {
        if (sw1==1){//mode1: amplitude control
            A=Ain;
            f=50000;
            T=1/f;
            Ts= T/SinNumPoints;
            for (int i=0;i<SinNumPoints;i++){
                Aout=0.5+A/2*sin(2*PI*f*i*Ts);
                wait(Ts);
        }else if(sw2==1){// mode2: period control
            A=1;
            f=50000*Ain;
            T=1/f;
            Ts= T/SinNumPoints;
            for (int i=0;i<SinNumPoints;i++){
                Aout=0.5+A/2*sin(2*PI*f*i*Ts);
                wait(Ts);
        }
            /* with 2 potenciometer to control simuntaneously both parameter, amplitude and frequency
            
            while(1){
                A=Ain1;
                f=50000*Ain2;(20ms)
                T=1/f;
                Ts=T/SinNumPoints;
                for (int i=0;i<SinNumPoints;i++){
                    Aout=0.5+A/2*sin(2*PI*f*i*Ts);
                    wait(Ts);
                }
            }
            
            */
    }

    }
}
