#include "mbed.h"
I2C MSP430G(p9, p10); //sda, sc1
Serial pc(USBTX, USBRX); //tx, rx
AnalogIn pin20(p20);
const int adresa=0x90;
char config_t[2];
char temp_read[2];
float napon1, napon2;
int i;

char SegConvert(float u1, float u2)   // function 'SegConvert'
{
    if(u1<=(0.1+u2)&&u1>=(u2-0.1)){
        i=1;
        }
    else if(u1>=0.1+u2){
        i=2;
        }
    else if (u1<=u2-0.1){
        i=3;
        }
    char SegValue=i;
    char SegByte=0x00;
    switch (SegValue) 
    { 
        case 1 :
            SegByte = 0x01;
            break;
        case 2 :
            SegByte = 0x04;
            break;
        case 3 :
            SegByte = 0x02;
            break;
                }
    return SegByte;
}

int main()
{
    while(1) 
    {
    config_t[0]=0xC1;
    config_t[1]=SegConvert(napon1,napon2);
    wait_us(20);
    MSP430G.write(adresa,config_t,2);
    napon1=pin20*3.3;
    MSP430G.read(adresa,temp_read,2);
    napon2=temp_read[0]+temp_read[1]*256;
    napon2=(napon2/1023)*1.5;
    pc.printf("Napon kojeg mjeri master iznosi: %.4f\n\r", napon1);
    pc.printf("Napon kojeg mjeri slave iznosi: %.4f\n\r", napon2);
    pc.printf("\n");
    wait(1);
}
}