/***************************************************
***********Prostorni svjetlomjer********************
* Na temelju izmjerenih fotonapona modulira se *****
* svjetlost LE dioda D1-D4. Dioda D5 pali se   *****
* kada je svjetlost iz svih smjerova jednaka   *****
*unutar vrijednosti od 5%                      *****
****************************************************
*/

#include "mbed.h"

Serial pc(USBTX, USBRX); //za i

AnalogIn LDR1(p17);     //Deklaracija Analognih ulaza 
AnalogIn LDR2(p18);     //za čitanje napona s LDR-a, 
AnalogIn LDR3(p19);     // ta vrijednost se kreće u granicama od 0 do 1
AnalogIn LDR4(p20);

PwmOut OUT1(p21);         //Deklaracija PWM izlaza za LED1
PwmOut OUT2(p22);         //Deklaracija PWM izlaza za LED2
PwmOut OUT3(p23);         //Deklaracija PWM izlaza za LED3
PwmOut OUT4(p24);         //Deklaracija PWM izlaza za LED4
PwmOut OUT5(p25);         //Deklaracija PWM izlaza za LED5

float IN1, IN2, IN3, IN4,PW, IN1min, IN1max, INmin;         //deklaracija varijabli za spremanje Analognih vrijednosti napona s LDR-a

int main() {                     //glavna funkcija

pc.printf("Vrijednosi A/D pretvorbe na fotootporniku:... \n\r");  //vijednosti A/D pretvorbe LDR-a
pc.printf("IN3,       IN4 \n\r");

    OUT1.period(0.010);          //postavljanje trajanja periode PWM signala na 10ms
    OUT2.period(0.010);          //za svih 5 izlaza OUT1 do OUT5
    OUT3.period(0.010);
    OUT4.period(0.010);
    OUT5.period(0.010);
    

    while(1) {                   //beskonačna petlja, non stop se vrti u krug; čita stanja ulaza i prema tome setira stanja izlaza
    
        OUT5.write(0);          //ugasi izlaz 5 tj. LED 5
  
        IN1=1-LDR1-0.2;         //INVERTIRAMO VRIJEDNOSTI
        IN2=1-LDR2-0.2;         //i umanjujemo za 0.2, inače se LED ne ugasi do kaja
        IN3=1-LDR3-0.2;  
        IN4=1-LDR4-0.2;
        
       
        OUT1.write(IN1);        //Izlaz OUT1 postavu u vrijednost varijable IN1
       
        OUT2.write(IN2);        //Izlaz OUT2 postavu u vrijednost varijable IN2
        
        OUT3.write(IN3);        //Izlaz OUT3 postavu u vrijednost varijable IN3
        
        OUT4.write(IN4);        //Izlaz OUT4 postavu u vrijednost varijable IN4
        wait(0.01);             //čekaj 10 ms
        
        INmin = IN1;            //traži najmanju vrijednost od 4 ulaza            
        if (INmin >= IN2){      //od IN1 do IN4 
            INmin = IN2;
            }
        else if (INmin >= IN3){
            INmin = IN3;
            }
            else if (INmin >= IN4){
                INmin = IN4;
            }      
            
        IN1min = 0,950 * INmin;        //da izvučemo 5% od najmanje vrijednost, minimalnavrijednost unutar 5%
        IN1max = 1,00 * INmin;        //maximalna vrijednost unutar 5%
        
         
         pc.printf("%f %f \n\r",IN3, IN4);
 
        
        if((IN1 < IN1max)&&(IN1 > IN1min)&&(IN2 < IN1max)&&(IN2 > IN1min)&&(IN3 < IN1max)&&(IN3 > IN1min)&&(IN4 < IN1max)&&(IN4 > IN1min)) {    //ispitujemo jesu li navedeni uvjeti ispunjeni i ako jesu...
            OUT5.write(1);                                                                                                                      //pali se dioda na izlazu OUT5
            wait(2);    
            
                                                                                                                                //čekaj 2 sekunde
        }
    }
}
