#include "mbed.h"
#include "rtos.h"
#include "nRF24L01P.h"
#include "Display1602.h"

//Mutex stdio_mutex;
Semaphore semMSP430G(1);
Semaphore semLCD(1);
Semaphore semJoystick(1);


I2C MSP430G(p9, p10); //sda, sc1
nRF24L01P odasiljac(p11,p12,p13,p14,p28,p27);  //// mosi, miso, sck, csn, ce, irq
AnalogIn upDown(p15);
AnalogIn leftRight(p16);
Display1602 display(p19, p20, p21, p22, p23, p24,p25,p26,p29,p30,p18); 
Serial pc(USBTX, USBRX);

DigitalOut myled1(LED1);
DigitalOut myled2(LED2);
DigitalOut myled3(LED3);
DigitalOut myled4(LED4);
DigitalOut res(p17);

void startLCD(void);
void startNRF(int);

void printTempAndVoltOnLCD(void const *args);
void printJoystickOnLCD(void const *args);

void readJoystick(void const *args);
void readTempFromMSP430G(void const *args);
void readVoltFromMSP430G(void const *args);

//nrf
const int transfer_size = 4;
char txData[transfer_size],rxData[transfer_size];
int txDataCnt = 0;
int rxDataCnt = 0;
    
//joystick
float velocity=upDown;
float direction =leftRight;
    
//MSP430g
const int addr= 0x94;
float temp=0.00;
float volt=0.00;

int testT=0;
int testY=0;


int main() 
{


    
     res=1;
    startLCD();
    startNRF(transfer_size);
    wait(1);
    
    Thread t0(readJoystick, (void *)"readJoystick");
    //Thread t1(readTempFromMSP430G, (void *)"readTemp");
    Thread t2(readVoltFromMSP430G, (void *)"readVoltage");
    Thread t3(printTempAndVoltOnLCD, (void *)"printTemp");
    Thread t4(printJoystickOnLCD, (void *)"printJoytick");
    
   
    
    
    //Thread t0(readJoystick, (void *)"readJoystick");
    //Thread t1(readTempFromMSP430G, (void *)"readTemp");
    //Thread t2(readVoltFromMSP430G, (void *)"readVoltage");
    //Thread t3(printTempAndVoltOnLCD, (void *)"printTemp");
    //Thread t4(printJoystickOnLCD, (void *)"printJoytick");
    
    //printTempAndVoltOnLCD((void *)"printemAndVolt");    
    //printJoystickOnLCD((void *)"printjoystick");
    //readJoystick((void *)"readJoystick");
    //readTempFromMSP430G((void *)"readTemp");
    
    
    //readVoltFromMSP430G((void *)"readVoltage");
    //Thread printOnLCD(temp,volt,1);
    //Thread t2(test_thread, (void *)"Th 2");
    
    while(1){}
    
}

void startLCD()
{
     display.Clear();
     display.SetXY(0,0);
     display.printf("Dorijan Macek"); // print on screen
     display.SetXY(0,1);
     display.printf("TVZ  2015 / 2016");
     wait(1);
     display.SetXY(0,0);
     display.printf("Dobro dosli  ");
     display.SetXY(0,1);
     display.printf("................");
     wait(0.5);    
}
void startNRF(int size)
{
    odasiljac.setTransferSize( size);
    odasiljac.setTransmitMode();
    odasiljac.enable();
    
    display.Clear();
    display.SetXY(0,0);
    display.printf( "Odasiljac ");
    display.SetXY(0,1);
    pc.printf( "                ");
    wait(1);
    display.Clear();
    
    display.printf( "Frequency : ");
    display.SetXY(0,1);
    display.printf ("%d MHz",odasiljac.getRfFrequency() );
    wait(1);
    display.Clear();
    display.SetXY(0,0);
    
    display.printf( "Output power : ");
    display.SetXY(0,1);
    display.printf("%d dBm",  odasiljac.getRfOutputPower() );
    wait(1);
    display.Clear();
    display.SetXY(0,0);
    
    display.printf( "Data Rate : ");
    display.SetXY(0,1);
    display.printf("%d kbps", odasiljac.getAirDataRate() );
    wait(1);
    display.Clear();
    display.SetXY(0,0);
    
    display.printf( "TX Address : ");
    display.SetXY(0,1);
    display.printf("0x%010llX", odasiljac.getTxAddress() );
    wait(1);
    display.Clear();
    display.SetXY(0,0);
    
    display.printf( "RX Address : ");
    display.SetXY(0,1);
    display.printf("0x%010llX", odasiljac.getRxAddress() );
    wait(1);
    display.Clear();
    display.SetXY(0,0);
    
    wait(0.5);
    
}

void printTempAndVoltOnLCD(void const *args)
{
    while(true)
    {
        semLCD.wait();
        
        int znakgore=30;
        int znakdolje=31;
        int znaklijevo=174;
        int znakdesno=175;
    
        display.SetXY(8,0);
        display.printf("T = %.2f ",temp);  
        display.SetXY(8,1);
        display.printf("V = %.2f ",volt);
        //pc.printf("printTempAndVoltOnLCD \n\r");
        
          
        Thread::wait(500);        
        semLCD.release();
    }  
}

void printJoystickOnLCD(void const *args)
{
    while(true)
    {
        semLCD.wait();
        
        display.SetXY(0,0);
        display.printf("Up %.2f ",velocity);
        display.SetXY(0,1);
        display.printf("LR %.2f ",direction);
        //pc.printf("printJoystickOnLCD \n\r ");
        
                
        Thread::wait(500);
        semLCD.release();
    }
}
        


void readJoystick(void const *args)
{
    while(true)
    {
        semJoystick.wait();
        
        velocity=upDown;
        direction =leftRight;
        //pc.printf("readJoystick \n\r ");
        
        Thread::wait(50);
        semJoystick.release();
    }
        
} 

void readTempFromMSP430G(void const *args)
{
    while(true)
    {
        semMSP430G.wait();
        //MSP430G.stop();
        //Thread::wait(500);

        //res=1;
        char config_t[2]; // transmitt buffer
        char value_read[2]; // read buffer
        config_t[0] = 0xC0; //config slave to int temp
        config_t[1] = 0x55; // config data byte1, BOut
        //MSP430G.start();
        //Thread::wait(20);
              
        MSP430G.write(addr, config_t, 2);
        Thread::wait(20);                                    
        //wait_us(20);
        MSP430G.read(addr, value_read, 2); //read the two-byte temp data            
        temp = ((value_read[0]+value_read[1]*256)/10.0);
        pc.printf("readTempFromMSP430G %f \n\r ",temp);
        res=0;
        Thread::wait(5);
        res=1;
        Thread::wait(500);
        
        //MSP430G.abort_transfer();
        //wait(0.5);
        
        
        //config_t[0] = 0xC1; //config slave to int temp
        //config_t[1] = 0xff; // config data byte1, BOut
        
        //MSP430G.write(addr, config_t, 2);
        //Thread::wait(20);                                    
        //wait_us(20);
        //MSP430G.read(addr, value_read, 2); //read the two-byte temp data
        //volt = ((value_read[0]+value_read[1]*256)*(1.5/1024));
        //pc.printf("readVoltFromMSP430G \n\r %f",volt);
        
        Thread::wait(500);
        
        //wait(0.5);
                      
        
        
        semMSP430G.release();    
    }    
}    


void readVoltFromMSP430G(void const *args)
{
    while(true)
    {
        semMSP430G.wait(); 
        //MSP430G.stop();
        
        char config_t[2]; // transmitt buffer
        char value_read[2]; // read buffer
        config_t[0] = 0xC1; //config slave to int temp
        config_t[1] = 0xff; // config data byte1, BOut
        //MSP430G.start();
          
        //Thread::wait(20);
        
        MSP430G.write(addr, config_t, 2);
        //MSP430G.stop();
        Thread::wait(20);
        
                       
        MSP430G.read(addr, value_read, 2); //read the two-byte temp data 
        //Thread::wait(500);
        
        volt = (value_read[0]+value_read[1]*256)*(1.5/1024);        
        pc.printf("readVoltFromMSP430G \n\r %f",volt);
        
        //MSP430G.stop();
        res=0;
        Thread::wait(5);
        res=1;
        Thread::wait(500);
        
        //MSP430G.stop();
        semMSP430G.release(); 
    }
}  


