#include "mbed.h"
#include "nRF24L01P.h"
#include "Display1602.h"

I2C MSP430G(p9, p10); //sda, sc1
nRF24L01P odasiljac(p11,p12,p13,p14,p28,p27);  //// mosi, miso, sck, csn, ce, irq
//AnalogIn speed(p15);
//AnalogIn direction(p26);
Display1602 display(p19, p20, p21, p22, p23, p24,p25,p26,p29,p30,p18); 
   
    

Serial pc(USBTX, USBRX); //tx, rx

//void start();
float readTempAndVoltage(int ,int, int , int);

int main() 
{


display.SetXY(0,0);
display.Print("Glupost je ");
display.SetXY(0,1);
display.Print("neunistiva!!!");

float t,v;

   
    
    while(1) 
    {
              
        t=readTempAndVoltage(0xC0,0x55,0x94,0);//55
        v=readTempAndVoltage(0xC1,0xff,0x94,1);//55
        
        //v=readTempAndVoltage(0xC1,0x55,0x94,1);
        
        //v=voltage(0xC1,0x55,0x94) ;   
        
               
        
        
        display.Clear();
        display.SetXY(0,0);
        display.printf("Temp = %.2f   C", t); // print on screen
        display.SetXY(0,1);
        display.printf("Voltage = %.2f V", v); // print on screen//wait(1);
        //display.SetXY(0,1);
        //display.printf("Voltage = %.1f V", voltage(0xC1,0x55,0x94)); // print on screen
        
    }
}

float readTempAndVoltage(int config_b0,int config_b1, int addr, int mode)
{
    char config_t[2]; // transmitt buffer
    char value_read[2]; // read buffer 
    wait(0.1);
    
    MSP430G.write(addr, config_t, 2);
    wait_us(20);
    
    if (mode==0)
        {
            float temp;
            config_t[0] = config_b0;    //0xC1; //config slave to int temp
            config_t[1] = config_b1;    //0x55; // config data byte1, BOut  
            MSP430G.read(addr, value_read, 2); //read the two-byte temp data 
            temp = value_read[0]+value_read[1]*256;
            temp=temp/10.;
            return temp;
        }
    else if(mode==1)
        {
            float voltage;
            config_t[0] = config_b0;    //0xC1; //config slave to int temp
            config_t[1] = config_b1;    //0x55; // config data byte1, BOut  
            MSP430G.read(addr, value_read, 2); //read the two-byte temp data 
            voltage = value_read[0]+value_read[1]*256;
            voltage = 1.5 * (voltage / 1023);
            return voltage;
        }
    else
        return 0;

}
