#include "mbed.h"
#include "math.h"

I2C MSP430G(p9, p10); //sda, sc1
Serial pc(USBTX, USBRX); //tx, rx

const int addr = 0x92;
char config_t[2]; // transmitt buffer
char temp_read[2]; // read buffer
float temp;
int temp_int;

char BOByte(int temp);


int main()
{
        config_t[0] = 0xC0; //config slave to int temp
        config_t[1] = 0xFF; // config data byte1, BOut
    
    while(1) {
        
        
        MSP430G.write(addr, config_t, 2);
        
        wait_us(20);
        
        MSP430G.read(addr, temp_read, 2); //read the two-byte temp data
        
        temp = temp_read[0]+temp_read[1]*256;
        temp = temp / 10;
        
        temp_int = ceil (temp); // float to integer, round to upper
        
        if ( temp_int >= 20 || temp_int <= 35) {
            
            config_t[1] = BOByte(temp_int); // config data byte1, BusOut
           
             pc.printf("Temp = %.1f degC\n\r", temp); // print on screen
        } else {
                 
                  config_t[1] = 0x00; // config data byte1, BOut
                  
                  pc.printf("Izmjerena temperatura je izvan mjernog opsega\n\r"); // print on screen
                  
        }
    wait(1);
            
    }
}
            
char BOByte(int temp) {
                      
    char BOut;
        
    switch(temp) {
            case 20: BOut = 0x01; break; 
            case 21: BOut = 0x01; break; 
            case 22: BOut = 0x03; break; 
            case 23: BOut = 0x03; break; 
            case 24: BOut = 0x07; break; 
            case 25: BOut = 0x07; break; 
            case 26: BOut = 0x0F; break; 
            case 27: BOut = 0x0F; break; 
            case 28: BOut = 0x1F; break; 
            case 29: BOut = 0x1F; break; 
            case 30: BOut = 0x3F; break; 
            case 31: BOut = 0x3F; break; 
            case 32: BOut = 0x7F; break; 
            case 33: BOut = 0x7F; break; 
            case 34: BOut = 0xFF; break; 
            case 35: BOut = 0xFF; break; 
            default: 
                BOut = 0x00;    
    }
    
    return BOut; // config data byte1, BOut
    
}