#include "mbed.h"
#include "QEI.h"

QEI wheel (p29, p30, NC, 512) ;
PwmOut PWM1(p22);
PwmOut PWM2(p21);
Serial pc(USBTX, USBRX);
Serial bluetooth(p28, p27,9600);


Ticker flipper1;

DigitalOut led1(LED1);
DigitalOut led2(LED2);
DigitalOut led3(LED3);
DigitalOut led4(LED4);
DigitalOut greanLed(p25);

AnalogIn Ain(p20);
float ADCdata;
int pulse=0;
float speed=0;
char buffer[5];
char *index=buffer;
int mod=0;

void rxCallbackBluetooth()
{

    char c=bluetooth.getc();

    *index=c;
    if (*index!=0x0D)
        index++;

}

void rxCallbackPC()
{

    char c=pc.getc();

    *index=c;
    if (*index!=0x0D)
        index++;

}

bool IsReadUART()
{
    if (*index==0x0D)
        return true;
    else
        return false;

}


void flip1()   
{

    pulse=wheel.getPulses();
    pc.printf("Pulses is: %i", pulse);
    speed=pulse/512.0;
    wheel.reset();
    pc.printf("  Speed is: %.2f", speed);
    pc.printf(" okr/s\n\r");
}

void init()
{
    PWM1.period(0.001);
    PWM2.period(0.001);
    flipper1.attach(&flip1, 1);
    pc.attach(&rxCallbackPC, Serial::RxIrq);
    bluetooth.attach(&rxCallbackBluetooth, Serial::RxIrq);
}

int main()
{
    init();
    int setSpeed;
    greanLed=1;
    while(1) {


        if(IsReadUART()) {
            mod=1;
            led1=true;
            led2=true;
            led3=true;
            led4=true;
            setSpeed=atoi(buffer);
            index=buffer;
            buffer[0]=0;
            buffer[1]=0;
            buffer[2]=0;
            buffer[3]=0;

            if((setSpeed>=0)&&(setSpeed<=100)) {
                PWM1=0;
                wait(0.01);
                PWM2=setSpeed/100.0;


            } else if((setSpeed<0)&&(setSpeed>=-100))  {
                PWM2=0;
                wait(0.01);
                PWM1=(setSpeed*-1)/100.0;


            } else if(setSpeed==255) {
                mod=0;
            }

        }
        if(mod==0) {
            ADCdata=Ain;

            if((ADCdata>=0)&&(ADCdata<0.45)) {
                PWM2=1-ADCdata*2.22;
                PWM1=0;
                led1=false;
                led2=false;
                led3=false;
                led4=true;

            } else if((ADCdata>0.55)&&(ADCdata<=1)) {
                PWM2=0;
                PWM1=(ADCdata-0.55)*2.22;
                led1=true;
                led2=false;
                led3=false;
                led4=false;
            } else {
                PWM1=0;
                PWM2=0;
                led1=false;
                led2=true;
                led3=true;
                led4=false;
            }
        }

       

    }
}
