#define USE_STM32L476G_DISCO_REVC
#include "stm32l476g_discovery.h"

// main() runs in its own thread in the OS
// (note the calls to wait below for delays)


/*************** TODO ***************
    Joystik up=> LED4 ON
    Joystik down=> LED5 ON

    Hint: Use UP_JOY_xxx definitions
*/
int main() {

    LED4_GPIO_CLK_ENABLE();
    LED5_GPIO_CLK_ENABLE();
    UP_JOY_GPIO_CLK_ENABLE();
    DOWN_JOY_GPIO_CLK_ENABLE();
    
    GPIO_InitTypeDef gpio;

    gpio.Mode = GPIO_MODE_OUTPUT_PP;
    gpio.Pull = GPIO_NOPULL;
    gpio.Speed = GPIO_SPEED_FREQ_LOW;
    gpio.Pin = LED4_PIN;
    HAL_GPIO_Init(LED4_GPIO_PORT, &gpio);

    gpio.Pin = LED5_PIN;
    HAL_GPIO_Init(LED5_GPIO_PORT, &gpio);


    gpio.Mode = GPIO_MODE_INPUT;
    gpio.Pull = GPIO_PULLDOWN;
    gpio.Pin = UP_JOY_PIN;
    HAL_GPIO_Init(UP_JOY_GPIO_PORT, &gpio);

    gpio.Pin = DOWN_JOY_PIN;
    HAL_GPIO_Init(DOWN_JOY_GPIO_PORT, &gpio);

    HAL_GPIO_TogglePin(LED5_GPIO_PORT, LED5_PIN);
    HAL_Delay(300);
    HAL_GPIO_TogglePin(LED4_GPIO_PORT, LED4_PIN);
    HAL_Delay(300);
    HAL_GPIO_TogglePin(LED5_GPIO_PORT, LED5_PIN);
    HAL_Delay(300);
    HAL_GPIO_TogglePin(LED4_GPIO_PORT, LED4_PIN);
    HAL_Delay(300);

    while (1) {
    }
}

