#include "mbed.h"
#include "m3pi_ng.h"
#include "btbee.h"

m3pi m3pi;
btbee btbee;

DigitalOut mbed_led[] = {(LED1), (LED2),(LED3), (LED4)};
DigitalOut m3pi_led[] = {(p13), (p14), (p15), (p16), (p17), (p18), (p19), (p20)};
DigitalIn m3pi_pb(p21);

Timer t1;

//LocalFileSystem local("local");    

int main()
{
    // initialization stuff ////////////////////////////////////////////////////////////////////////////////////////////////////
    m3pi.locate(0,1);
    btbee.reset();
    for (int i = 0; i <4; i++) {
        mbed_led[i] = 0;
    }
    for (int i = 0; i <8; i++) {
        m3pi_led[i]=0;
    }
    m3pi_pb.mode(PullUp); // expected would be 1 when pb is pressed, 0 when not, opposite is the case

    // NOTE on baud rate: the baud rate to be used has to be set on the btBee beforehand. this uses the at mode which is activated by hardware switch.
    // only use the hw switch while powered off. use the configure_btbee program to write to it.
    //btbee.baud(9600);  // this is BtBee default for regular commands
    //btbee.baud(115200);  // this is BtBee regular command set baud rate
    //btbee.format();  // the default should be fine

    // end initialization stuff ////////////////////////////////////////////////////////////////////////////////////////////////

    // let me play you the song of my people...
    // V=volume max is 15::O5=octave5::G16=G16th note::R24=rest24th note...a rest is needed between any two note that are the same
    //char dixie[]= {'V','1','5','O','5','G','1','6','E','1','6','C','8','R','2','4','C','8','R','2','4','C','1','6','D','1','6','E','1','6','F','1','6','G','8','R','2','4','G','8','R','2','4','G','8','E','1','6'};
    //the number of characters in the array
    //int len=49;
    //m3pi.playtune(dixie,len);
    m3pi.locate(0,0);
    m3pi.printf("B:%0.3f%V",m3pi.battery());
    wait(0.3);
    
/*    m3pi.locate(0,0);
    m3pi.printf("%s","fileTest");

    FILE *fp = fopen("/local/out.txt", "w");  // Open "out.txt" on the local file system for writing
    fprintf(fp, "Hello World!");
    fclose(fp);

    m3pi.locate(0,1);
    m3pi.printf("%s","doneTest");
    
*/    
    m3pi.locate(0,0);
    m3pi.printf("%s","btTest");
    m3pi.locate(0,1);
    m3pi.printf("%s","PBonLNK");

    // wait for the user to push P21, should be pressed when the bt link is established (green led "link")
    while(m3pi_pb) {
        m3pi_led[0]=!m3pi_led[0];
        wait(0.1);
    }

    int iline=1;
    int write = 1; // this could also be a boolean
    char arr_read[30]; // this should be long enough to store any reply coming in over bt.
    int  chars_read;   // number of chars read in a bt reply
    
    while (true) {
       
        // this writes "Line 001\n" to "Line 005\n" and then "end\n" to the btbee
        if (btbee.writeable() && write ) {
            if (iline==6) {
                btbee.printf("end\n");
                write=1;
                iline=7;
            }//if
            else {
                if (iline <6){
                btbee.printf("Line %0.3d \n",iline);
                m3pi_led[0]=0;
                m3pi.locate(0,0);
                m3pi.printf("Sent %0.3d",iline);
                iline++;
                }
            }//else
        }//if_write

        // check for answers after each write /not write
        while (btbee.readable()) {
            m3pi_led[7]=1;
            btbee.read_all(arr_read, 30, &chars_read );
            m3pi_led[6]=1;
            m3pi.locate(0,1);
            m3pi.print(arr_read,chars_read);
            m3pi_led[5]=1;
        }//while_readable
        wait(0.1);
    }//while true

}//main



